/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.implementations.ServiceUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.persistence.CouchDBPersistence;
import org.gcube.accounting.persistence.FallbackPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Persistence {
    private static final Logger logger = LoggerFactory.getLogger(Persistence.class);
    private static final String ACCOUTING_FALLBACK_FILENAME = "accountingFallback.log";
    protected static Persistence persistence;
    protected static FallbackPersistence fallback;
    private ExecutorService pool = Executors.newCachedThreadPool();

    private static File file(File file) throws IllegalArgumentException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " cannot be used in write mode because it's folder");
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    public static synchronized void setFallbackLocation(String path) {
        if (fallback == null) {
            if (path == null) {
                path = ".";
            }
            File file = Persistence.file(new File(path, ACCOUTING_FALLBACK_FILENAME));
            fallback = new FallbackPersistence(file);
        }
    }

    protected static void init() {
        Persistence.setFallbackLocation(null);
        try {
            persistence = new CouchDBPersistence();
            persistence.prepareConnection();
            persistence.account(Persistence.createTestUsageRecord());
        }
        catch (Exception e) {
            logger.error("Unable to instance {}. Using fallback as default", (Object)CouchDBPersistence.class.getSimpleName());
            persistence = fallback;
        }
    }

    public static UsageRecord createTestUsageRecord() {
        ServiceUsageRecord serviceUsageRecord = new ServiceUsageRecord();
        try {
            serviceUsageRecord.setCreatorId("accounting");
            serviceUsageRecord.setConsumerId("accounting");
            serviceUsageRecord.setResourceScope("/gcube/devsec");
            serviceUsageRecord.setResourceProperty("ConnectionTest", (Serializable)((Object)"Test"));
            serviceUsageRecord.setServiceClass("Accounting");
            serviceUsageRecord.setServiceName("Accounting-Lib");
            serviceUsageRecord.setRefHost("localhost");
            serviceUsageRecord.setRefVM("local");
            serviceUsageRecord.setCallerScope("/gcube/devsec");
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return serviceUsageRecord;
    }

    public static Persistence getInstance() {
        if (persistence == null) {
            Persistence.init();
        }
        return persistence;
    }

    protected Persistence() {
    }

    protected abstract void prepareConnection() throws Exception;

    protected abstract void reallyAccount(UsageRecord var1) throws Exception;

    private void accountWithFallback(UsageRecord usageRecord) throws Exception {
        String persistenceName = Persistence.getInstance().getClass().getSimpleName();
        try {
            persistence.reallyAccount(usageRecord);
            logger.debug("{} accounted succesfully from {}.", (Object)usageRecord, (Object)persistenceName);
        }
        catch (Exception e) {
            String fallabackPersistenceName = fallback.getClass().getSimpleName();
            try {
                logger.error("{} was not accounted succesfully from {}. Trying to use {}.", new Object[]{usageRecord, persistenceName, fallabackPersistenceName});
                fallback.reallyAccount(usageRecord);
                logger.debug("{} accounted succesfully from {}", (Object)usageRecord, (Object)fallabackPersistenceName);
            }
            catch (Exception ex) {
                logger.error("{} was not accounted at all", (Object)usageRecord);
                throw e;
            }
        }
    }

    public void account(final UsageRecord usageRecord) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    persistence.accountWithFallback(usageRecord);
                }
                catch (Exception e) {
                    logger.error("Error accouting UsageRecod", e.getCause());
                }
            }
        };
        this.pool.execute(runnable);
    }

    public abstract void close() throws Exception;
}

