/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.datamodel.decorators.FieldDecorator;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.DeprecatedWarning;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.NotEmptyIfNotNull;
import org.gcube.accounting.datamodel.validations.validators.NotEmptyIfNotNullValidator;
import org.gcube.accounting.exception.InvalidValueException;

public abstract class PortletUsageRecord
extends BasicUsageRecord {
    private static final long serialVersionUID = 8339324883678974869L;
    @DeprecatedWarning
    @MoveToConsumerId
    protected static final String USER_ID = "userId";
    @RequiredField
    @NotEmpty
    public static final String PORTLET_ID = "portletId";
    @RequiredField
    @NotEmpty
    public static final String OPERATION_ID = "operationId";
    @NotEmptyIfNotNull
    public static final String MESSAGE = "message";

    public PortletUsageRecord() {
    }

    public PortletUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public String getPortletId() {
        return (String)this.resourceProperties.get(PORTLET_ID);
    }

    public void setPortletId(String portletId) throws InvalidValueException {
        this.setResourceProperty(PORTLET_ID, (Serializable)((Object)portletId));
    }

    public String getOperationId() {
        return (String)this.resourceProperties.get(OPERATION_ID);
    }

    public void setOperationId(String operationId) throws InvalidValueException {
        this.setResourceProperty(OPERATION_ID, (Serializable)((Object)operationId));
    }

    public String getMessage() {
        return (String)this.resourceProperties.get(MESSAGE);
    }

    public void setMessage(String message) throws InvalidValueException {
        this.setResourceProperty(MESSAGE, (Serializable)((Object)message));
    }

    protected class MoveToConsumerIdAction
    implements FieldAction {
        protected MoveToConsumerIdAction() {
        }

        @Override
        public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException {
            NotEmptyIfNotNullValidator neinnv = new NotEmptyIfNotNullValidator();
            value = neinnv.validate(key, value, usageRecord);
            usageRecord.setConsumerId((String)((Object)value));
            return value;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @FieldDecorator(managed=MoveToConsumerIdAction.class)
    protected static @interface MoveToConsumerId {
    }
}

