/**
 * 
 */
package org.gcube.accounting.persistence;

import java.util.concurrent.TimeUnit;

import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class AccountingPersistence {
	
	private static final AccountingPersistence accountingPersistence;
	
	private AccountingPersistence(){}
	
	static {
		accountingPersistence = new AccountingPersistence();
	}
	
	protected static synchronized AccountingPersistence getInstance(){
		return accountingPersistence;
	}
	
	/**
	 * Persist the {@link #UsageRecord}.
	 * The Record is validated first, then accounted, in a separated thread. 
	 * So that the program can continue the execution.
	 * If the persistence fails the class write that the record in a local file
	 * so that the {@link #UsageRecord} can be recorder later.
	 * @param usageRecord the {@link #UsageRecord} to persist
	 * @throws InvalidValueException if the Record Validation Fails
	 */
	public void account(final SingleUsageRecord usageRecord) throws InvalidValueException{
		AccountingPersistenceBackendFactory.getPersistenceBackend().account(usageRecord);
	}
	
	public void flush(long timeout, TimeUnit timeUnit) throws Exception {
		AccountingPersistenceBackendFactory.flushAll(timeout, timeUnit);
	}
	
	public void close() throws Exception{
		AccountingPersistenceBackendFactory.getPersistenceBackend().close();
	}
	
}
