/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.gcube.accounting.aggregation.scheduler.AggregationScheduler;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.persistence.AccountingPersistenceBackend;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;

public class FallbackPersistenceBackend
extends AccountingPersistenceBackend {
    private File accountingFallbackFile;

    protected File getAccountingFallbackFile() {
        return this.accountingFallbackFile;
    }

    protected FallbackPersistenceBackend(File accountingFallbackFile) {
        super(null, AggregationScheduler.newInstance());
        this.accountingFallbackFile = accountingFallbackFile;
    }

    @Override
    public void prepareConnection(AccountingPersistenceConfiguration configuration) {
    }

    @Override
    protected void reallyAccount(UsageRecord usageRecord) throws Exception {
        this.printLine(String.valueOf(usageRecord));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLine(String line) throws Exception {
        File file = this.accountingFallbackFile;
        synchronized (file) {
            try (FileWriter fw = new FileWriter(this.accountingFallbackFile, true);
                 BufferedWriter bw = new BufferedWriter(fw);
                 PrintWriter out = new PrintWriter(bw);){
                out.println(line);
                out.flush();
            }
        }
    }

    @Override
    public void close() throws Exception {
    }
}

