/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregation.scheduler.AggregationScheduler;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.persistence.AccountingPersistenceBackendMonitor;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.accounting.persistence.AccountingPersistenceExecutor;
import org.gcube.accounting.persistence.FallbackPersistenceBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccountingPersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceBackend.class);
    protected FallbackPersistenceBackend fallbackPersistence;
    protected AggregationScheduler aggregationScheduler;
    protected AccountingPersistenceBackendMonitor accountingPersistenceBackendMonitor;
    private ExecutorService pool = Executors.newCachedThreadPool();

    protected AccountingPersistenceBackend() {
        if (!(this instanceof FallbackPersistenceBackend)) {
            this.accountingPersistenceBackendMonitor = new AccountingPersistenceBackendMonitor(this);
        }
    }

    protected AccountingPersistenceBackend(FallbackPersistenceBackend fallback, AggregationScheduler aggregationScheduler) {
        this();
        this.fallbackPersistence = fallback;
        this.aggregationScheduler = aggregationScheduler;
    }

    public FallbackPersistenceBackend getFallbackPersistence() {
        return this.fallbackPersistence;
    }

    protected void setFallback(FallbackPersistenceBackend fallback) {
        this.fallbackPersistence = fallback;
    }

    public AggregationScheduler getAggregationScheduler() {
        return this.aggregationScheduler;
    }

    protected void setAggregationScheduler(AggregationScheduler aggregationScheduler) {
        this.aggregationScheduler = aggregationScheduler;
    }

    protected abstract void prepareConnection(AccountingPersistenceConfiguration var1) throws Exception;

    protected abstract void reallyAccount(UsageRecord var1) throws Exception;

    protected void accountWithFallback(UsageRecord ... usageRecords) {
        String persistenceName = this.getClass().getSimpleName();
        logger.trace("Going to account {} using {} : {}", new Object[]{Arrays.toString(usageRecords), persistenceName, this});
        for (UsageRecord usageRecord : usageRecords) {
            try {
                logger.trace("Going to account {} using {} : {}", new Object[]{usageRecord, persistenceName, this});
                this.reallyAccount(usageRecord);
                logger.debug("{} accounted succesfully from {}.", (Object)usageRecord.toString(), (Object)persistenceName);
            }
            catch (Exception e) {
                try {
                    String fallabackPersistenceName = FallbackPersistenceBackend.class.getSimpleName();
                    logger.error("{} was not accounted succesfully from {}. Trying to use {}.", new Object[]{usageRecord.toString(), persistenceName, fallabackPersistenceName, e});
                    this.fallbackPersistence.reallyAccount(usageRecord);
                    logger.debug("{} accounted succesfully from {}", (Object)usageRecord.toString(), (Object)fallabackPersistenceName);
                }
                catch (Exception ex) {
                    logger.error("{} was not accounted at all", (Object)usageRecord.toString(), (Object)e);
                }
            }
        }
    }

    protected void validateAccountAggregate(SingleUsageRecord usageRecord, boolean validate, boolean aggregate) {
        try {
            logger.debug("Received record to account : {}", (Object)usageRecord);
            if (validate) {
                usageRecord.validate();
                logger.trace("Record {} valid", (Object)usageRecord);
            }
            if (aggregate) {
                final AccountingPersistenceBackend persistence = this;
                this.aggregationScheduler.aggregate(usageRecord, new AccountingPersistenceExecutor(){

                    @Override
                    public void persist(UsageRecord ... usageRecords) throws Exception {
                        persistence.accountWithFallback(usageRecords);
                    }
                });
            } else {
                this.accountWithFallback(usageRecord);
            }
        }
        catch (InvalidValueException e) {
            logger.error("Error validating UsageRecord", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Error accounting UsageRecord", (Throwable)e);
        }
    }

    public void account(final SingleUsageRecord usageRecord) throws InvalidValueException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AccountingPersistenceBackend.this.validateAccountAggregate(usageRecord, true, true);
            }
        };
        this.pool.execute(runnable);
    }

    public void flush(long timeout, TimeUnit timeUnit) throws Exception {
        this.pool.awaitTermination(timeout, timeUnit);
        final AccountingPersistenceBackend persistence = this;
        this.aggregationScheduler.flush(new AccountingPersistenceExecutor(){

            @Override
            public void persist(UsageRecord ... usageRecords) throws Exception {
                persistence.accountWithFallback(usageRecords);
            }
        });
    }

    public abstract void close() throws Exception;
}

