/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.persistence.AccountingPersistenceBackend;
import org.gcube.accounting.persistence.FallbackPersistenceBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingPersistenceBackendMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceBackendMonitor.class);
    private static final String ELABORATION_FILE_SUFFIX = ".ELABORATION";
    private static final String ELABORATION_FILE_NOT_DELETED_SUFFIX = ".ELABORATION.NOT-DELETED";
    protected final ScheduledExecutorService scheduler;
    protected final AccountingPersistenceBackend accountingPersistenceBackend;

    public AccountingPersistenceBackendMonitor(AccountingPersistenceBackend accountingPersistenceBackend) {
        this.accountingPersistenceBackend = accountingPersistenceBackend;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(this, 10L, 10L, TimeUnit.MINUTES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void elaborateFile(File elaborationFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(elaborationFile));){
            String line;
            while ((line = br.readLine()) != null) {
                try {
                    UsageRecord usageRecord = BasicUsageRecord.getUsageRecord(line);
                    this.accountingPersistenceBackend.accountWithFallback(usageRecord);
                }
                catch (Exception e) {
                    logger.error("Was not possible parse line {} to obtain a valid UsageRecord. Going to writing back this line as string fallback file.", (Object)line, (Object)e);
                    FallbackPersistenceBackend fallbackPersistenceBackend = this.accountingPersistenceBackend.getFallbackPersistence();
                    try {
                        fallbackPersistenceBackend.printLine(line);
                    }
                    catch (Exception e1) {
                        logger.error("Was not possible Line {} will be lost", (Object)line, (Object)e1);
                    }
                }
            }
            return;
        }
        catch (FileNotFoundException e) {
            logger.error("", (Throwable)e);
            return;
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Trying to persist {}s which failed and were persisted using fallback", (Object)UsageRecord.class.getSimpleName());
        FallbackPersistenceBackend fallbackPersistenceBackend = this.accountingPersistenceBackend.getFallbackPersistence();
        File file = fallbackPersistenceBackend.getAccountingFallbackFile();
        File elaborationFile = null;
        File file2 = file;
        synchronized (file2) {
            if (file.exists()) {
                elaborationFile = new File(file.getAbsolutePath() + ELABORATION_FILE_SUFFIX);
                file.renameTo(elaborationFile);
            }
        }
        if (elaborationFile != null) {
            file2 = elaborationFile;
            synchronized (file2) {
                this.elaborateFile(elaborationFile);
                boolean deleted = elaborationFile.delete();
                if (!deleted) {
                    logger.debug("Failed to delete file {}", (Object)elaborationFile.getAbsolutePath());
                    File elaborationFileNotDeleted = new File(elaborationFile.getAbsolutePath() + ELABORATION_FILE_NOT_DELETED_SUFFIX);
                    elaborationFile.renameTo(elaborationFileNotDeleted);
                }
            }
        }
    }
}

