/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import java.io.Serializable;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractJobUsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.exception.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateWallDurationAction
implements FieldAction {
    private static final Logger logger = LoggerFactory.getLogger(CalculateWallDurationAction.class);

    @Override
    public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException {
        try {
            long wallDuration = ((AbstractJobUsageRecord)usageRecord).calculateWallDuration();
            if (key.compareTo("wallDuration") == 0) {
                logger.warn("{} is automatically computed using {} and {}. This invocation has the only effect of recalculating the value. Any provided value is ignored.", new Object[]{"wallDuration", "jobStartTime", "jobEndTime"});
                value = Long.valueOf(wallDuration);
            }
        }
        catch (InvalidValueException e) {
            // empty catch block
        }
        return value;
    }
}

