/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.util.concurrent.TimeUnit;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.persistence.AccountingPersistenceBackendFactory;

public class AccountingPersistence {
    private static final AccountingPersistence accountingPersistence = new AccountingPersistence();

    private AccountingPersistence() {
    }

    protected static synchronized AccountingPersistence getInstance() {
        return accountingPersistence;
    }

    public void account(SingleUsageRecord usageRecord) throws InvalidValueException {
        AccountingPersistenceBackendFactory.getPersistenceBackend().account(usageRecord);
    }

    public void flush(long timeout, TimeUnit timeUnit) throws Exception {
        AccountingPersistenceBackendFactory.flushAll(timeout, timeUnit);
    }

    public void close() throws Exception {
        AccountingPersistenceBackendFactory.getPersistenceBackend().close();
    }
}

