/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregation.scheduler.AggregationScheduler;
import org.gcube.accounting.persistence.AccountingPersistenceBackend;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.accounting.persistence.FallbackPersistenceBackend;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccountingPersistenceBackendFactory {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceBackendFactory.class);
    public static final String HOME_SYSTEM_PROPERTY = "user.home";
    private static final String ACCOUTING_FALLBACK_FILENAME = "accountingFallback.log";
    private static String fallbackLocation;
    private static Map<String, AccountingPersistenceBackend> accountingPersistenceBackends;
    private static Map<String, Long> fallbackLastCheck;
    public static final long FALLBACK_RETRY_TIME = 600000L;

    protected static Long getFallbackLastCheck(String scope) {
        return fallbackLastCheck.get(scope);
    }

    private static File file(File file) throws IllegalArgumentException {
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    protected static synchronized void setFallbackLocation(String path) {
        if (fallbackLocation == null) {
            if (path == null) {
                path = System.getProperty(HOME_SYSTEM_PROPERTY);
            }
            AccountingPersistenceBackendFactory.file(new File(path));
            fallbackLocation = path;
        }
    }

    protected static FallbackPersistenceBackend createFallback(String scope) {
        logger.debug("Creating {} for scope {}", (Object)FallbackPersistenceBackend.class.getSimpleName(), (Object)scope);
        File fallbackFile = null;
        if (scope != null) {
            ScopeBean bean = new ScopeBean(scope);
            String name = bean.name();
            fallbackFile = new File(fallbackLocation, String.format("%s.%s", name, ACCOUTING_FALLBACK_FILENAME));
        } else {
            fallbackFile = new File(fallbackLocation, ACCOUTING_FALLBACK_FILENAME);
        }
        FallbackPersistenceBackend fallbackPersistence = new FallbackPersistenceBackend(fallbackFile);
        fallbackPersistence.setAggregationScheduler(AggregationScheduler.newInstance());
        return fallbackPersistence;
    }

    protected static AccountingPersistenceBackend discoverAccountingPersistenceBackend(String scope) {
        logger.debug("Discovering {} for scope {}", (Object)AccountingPersistenceBackend.class.getSimpleName(), (Object)scope);
        ServiceLoader<AccountingPersistenceBackend> serviceLoader = ServiceLoader.load(AccountingPersistenceBackend.class);
        for (AccountingPersistenceBackend foundPersistence : serviceLoader) {
            try {
                String foundPersistenceClassName = foundPersistence.getClass().getSimpleName();
                logger.debug("Testing {}", (Object)foundPersistenceClassName);
                AccountingPersistenceConfiguration configuration = new AccountingPersistenceConfiguration(foundPersistenceClassName);
                foundPersistence.prepareConnection(configuration);
                logger.debug("{} will be used.", (Object)foundPersistenceClassName);
                foundPersistence.setAggregationScheduler(AggregationScheduler.newInstance());
                foundPersistence.setFallback(AccountingPersistenceBackendFactory.createFallback(scope));
                return foundPersistence;
            }
            catch (Exception e) {
                logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", foundPersistence.getClass().getSimpleName()), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AccountingPersistenceBackend rediscoverAccountingPersistenceBackend(AccountingPersistenceBackend actual, String scope) {
        Long now = Calendar.getInstance().getTimeInMillis();
        Long lastCheckTimestamp = fallbackLastCheck.get(scope);
        logger.debug("Last check for scope {} was {}", (Object)scope, (Object)lastCheckTimestamp);
        boolean myTurn = false;
        Map<String, AccountingPersistenceBackend> map = accountingPersistenceBackends;
        synchronized (map) {
            if (lastCheckTimestamp + 600000L <= now) {
                logger.debug("The {} for scope {} is {}. Is time to rediscover if there is another possibility.", new Object[]{AccountingPersistenceBackend.class.getSimpleName(), scope, actual.getClass().getSimpleName()});
                logger.trace("Renewing Last check Timestamp. The next one will be {}", (Object)now);
                fallbackLastCheck.put(scope, now);
                myTurn = true;
                logger.debug("I win. It is my turn to rediscover {} in scope {}", (Object)AccountingPersistenceBackend.class.getSimpleName(), (Object)scope);
            }
        }
        if (myTurn) {
            AccountingPersistenceBackend discoveredPersistenceBackend = AccountingPersistenceBackendFactory.discoverAccountingPersistenceBackend(scope);
            Map<String, AccountingPersistenceBackend> map2 = accountingPersistenceBackends;
            synchronized (map2) {
                if (discoveredPersistenceBackend != null) {
                    discoveredPersistenceBackend.setAggregationScheduler(actual.getAggregationScheduler());
                    fallbackLastCheck.remove(scope);
                    accountingPersistenceBackends.put(scope, discoveredPersistenceBackend);
                    return discoveredPersistenceBackend;
                }
            }
        }
        long nextCheck = lastCheckTimestamp + 600000L - Calendar.getInstance().getTimeInMillis();
        float nextCheckInSec = nextCheck / 1000L;
        logger.debug("The {} for scope {} is going to be used is {}. Next retry in {} msec (about {} sec)", new Object[]{AccountingPersistenceBackend.class.getSimpleName(), scope, actual.getClass().getSimpleName(), nextCheck, Float.valueOf(nextCheckInSec)});
        return actual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AccountingPersistenceBackend getPersistenceBackend() {
        String scope = ScopeProvider.instance.get();
        if (scope == null) {
            logger.error("No Scope available. FallbackPersistence will be used");
            return AccountingPersistenceBackendFactory.createFallback(null);
        }
        AccountingPersistenceBackend persistence = null;
        logger.debug("Going to synchronized block in getPersistenceBackend");
        Map<String, AccountingPersistenceBackend> map = accountingPersistenceBackends;
        synchronized (map) {
            persistence = accountingPersistenceBackends.get(scope);
            logger.debug("{} {}", (Object)AccountingPersistenceBackend.class.getSimpleName(), (Object)persistence);
            if (persistence == null) {
                persistence = AccountingPersistenceBackendFactory.createFallback(scope);
                accountingPersistenceBackends.put(scope, persistence);
                long now = Calendar.getInstance().getTimeInMillis();
                fallbackLastCheck.put(scope, now - 600000L - 1L);
            }
        }
        if (persistence instanceof FallbackPersistenceBackend) {
            persistence = AccountingPersistenceBackendFactory.rediscoverAccountingPersistenceBackend(persistence, scope);
        }
        return persistence;
    }

    public static void flushAll(long timeout, TimeUnit timeUnit) {
        for (String scope : accountingPersistenceBackends.keySet()) {
            AccountingPersistenceBackend apb = accountingPersistenceBackends.get(scope);
            try {
                logger.debug("Flushing records in scope {}", (Object)scope);
                apb.flush(timeout, timeUnit);
            }
            catch (Exception e) {
                logger.error("Unable to flush records in scope {} with {}", (Object)scope, (Object)apb);
            }
        }
    }

    static {
        accountingPersistenceBackends = new HashMap<String, AccountingPersistenceBackend>();
        fallbackLastCheck = new HashMap<String, Long>();
    }
}

