/**
 * 
 */
package org.gcube.accounting.datamodel.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;

import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.implementation.AggregatedField;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

/**
 * This Class is for library internal use only
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class AggregatedStorageUsageRecord extends AbstractStorageUsageRecord implements AggregatedUsageRecord<AggregatedStorageUsageRecord, StorageUsageRecord> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 1082525518686785682L;
	
	// Redefining DATA_VOLUME to Set @AggregatedField
	@RequiredField @ValidLong @AggregatedField
	public static final String DATA_VOLUME = AbstractStorageUsageRecord.DATA_VOLUME;

	
	public AggregatedStorageUsageRecord() {
		super();
	}
	
	public AggregatedStorageUsageRecord(Map<String, Comparable<? extends Serializable>> properties) throws InvalidValueException{
		super(properties);
	}

	public AggregatedStorageUsageRecord(StorageUsageRecord record) throws InvalidValueException{
		super(record.getResourceProperties());
		this.setOperationCount(1);
		Calendar creationTime = record.getCreationTime();
		this.setCreationTime(Calendar.getInstance());
		this.setStartTime(creationTime);
		this.setEndTime(creationTime);
	}
	
	@Override
	public int getOperationCount() {
		return super.getOperationCount();
	}

	@Override
	public void setOperationCount(int operationCount) throws InvalidValueException {
		super.setOperationCount(operationCount);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Calendar getStartTime() {
		return super.getStartTimeAsCalendar();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setStartTime(Calendar startTime) throws InvalidValueException {
		super.setStartTime(startTime);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Calendar getEndTime() {
		return super.getEndTimeAsCalendar();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setEndTime(Calendar endTime) throws InvalidValueException {
		super.setEndTime(endTime);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public AggregatedStorageUsageRecord aggregate(
			AggregatedStorageUsageRecord record)
			throws NotAggregatableRecordsExceptions {
		try {
			this.setOperationCount(this.getOperationCount() + record.getOperationCount());
			this.setDataVolume(this.getDataVolume() + record.getDataVolume());
		}catch(Exception e){
			throw new UnsupportedOperationException(e);
		}
		
		return this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public AggregatedStorageUsageRecord aggregate(StorageUsageRecord record)
			throws NotAggregatableRecordsExceptions {
		try {
			return aggregate(new AggregatedStorageUsageRecord(record));
		} catch (InvalidValueException e) {
			throw new NotAggregatableRecordsExceptions(e.getCause());
		}
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Class<StorageUsageRecord> getAggregable() {
		return StorageUsageRecord.class;
	}
	
}
