/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.aggregation.AggregationUtility;
import org.gcube.documentstore.records.implementation.AggregatedField;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

public class AggregatedStorageUsageRecord
extends AbstractStorageUsageRecord
implements AggregatedUsageRecord<AggregatedStorageUsageRecord, StorageUsageRecord> {
    private static final long serialVersionUID = 1082525518686785682L;
    @RequiredField
    @ValidLong
    @AggregatedField
    public static final String DATA_VOLUME = "dataVolume";

    public AggregatedStorageUsageRecord() {
    }

    public AggregatedStorageUsageRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public AggregatedStorageUsageRecord(StorageUsageRecord record) throws InvalidValueException {
        super(record.getResourceProperties());
        this.setOperationCount(1);
        Calendar creationTime = record.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
    }

    public Set<String> getAggregatedFields() {
        return this.aggregatedFields;
    }

    public int getOperationCount() {
        return super.getOperationCount();
    }

    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    public Calendar getStartTime() {
        return super.getStartTimeAsCalendar();
    }

    public void setStartTime(Calendar startTime) throws InvalidValueException {
        super.setStartTime(startTime);
    }

    public Calendar getEndTime() {
        return super.getEndTimeAsCalendar();
    }

    public void setEndTime(Calendar endTime) throws InvalidValueException {
        super.setEndTime(endTime);
    }

    public AggregatedStorageUsageRecord aggregate(AggregatedStorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            AggregationUtility aggregationUtility = new AggregationUtility((AggregatedRecord)this);
            aggregationUtility.aggregate((AggregatedRecord)record);
            this.setDataVolume(this.getDataVolume() + record.getDataVolume());
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions((Throwable)ex);
        }
        return this;
    }

    public AggregatedStorageUsageRecord aggregate(StorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.aggregate(new AggregatedStorageUsageRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions((Throwable)ex);
        }
    }

    public boolean isAggregable(AggregatedStorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        AggregationUtility aggregationUtility = new AggregationUtility((AggregatedRecord)this);
        return aggregationUtility.isAggregable((AggregatedRecord)record);
    }

    public boolean isAggregable(StorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.isAggregable(new AggregatedStorageUsageRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions((Throwable)ex);
        }
    }

    public Class<StorageUsageRecord> getAggregable() {
        return StorageUsageRecord.class;
    }
}

