/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.aggregation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractPortletUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.PortletUsageRecord;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.aggregation.AggregationUtility;

@JsonTypeName(value="PortletUsageRecord")
public class AggregatedPortletUsageRecord
extends AbstractPortletUsageRecord
implements AggregatedUsageRecord<AggregatedPortletUsageRecord, PortletUsageRecord> {
    private static final long serialVersionUID = 7445526162102677455L;

    public AggregatedPortletUsageRecord() {
    }

    public AggregatedPortletUsageRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public AggregatedPortletUsageRecord(PortletUsageRecord portletUsageRecord) throws InvalidValueException {
        super(portletUsageRecord.getResourceProperties());
        this.setOperationCount(1);
        Calendar creationTime = portletUsageRecord.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
    }

    @JsonIgnore
    public int getOperationCount() {
        return super.getOperationCount();
    }

    @JsonIgnore
    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    @JsonIgnore
    public Calendar getStartTime() {
        return super.getStartTimeAsCalendar();
    }

    @JsonIgnore
    public void setStartTime(Calendar startTime) throws InvalidValueException {
        super.setStartTime(startTime);
    }

    @JsonIgnore
    public Calendar getEndTime() {
        return super.getEndTimeAsCalendar();
    }

    @JsonIgnore
    public void setEndTime(Calendar endTime) throws InvalidValueException {
        super.setEndTime(endTime);
    }

    @JsonIgnore
    public void setAggregate(Boolean aggregate) throws InvalidValueException {
        super.setAggregate(aggregate);
    }

    @JsonIgnore
    public Boolean getAggregate() {
        return super.getAggregate();
    }

    @JsonIgnore
    public AggregatedPortletUsageRecord aggregate(AggregatedPortletUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            AggregationUtility aggregationUtility = new AggregationUtility((AggregatedRecord)this);
            aggregationUtility.aggregate((AggregatedRecord)record);
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions((Throwable)ex);
        }
        return this;
    }

    @JsonIgnore
    public AggregatedPortletUsageRecord aggregate(PortletUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.aggregate(new AggregatedPortletUsageRecord(record));
        }
        catch (InvalidValueException e) {
            throw new NotAggregatableRecordsExceptions(e.getCause());
        }
    }

    public boolean isAggregable(AggregatedPortletUsageRecord record) throws NotAggregatableRecordsExceptions {
        AggregationUtility aggregationUtility = new AggregationUtility((AggregatedRecord)this);
        return aggregationUtility.isAggregable((AggregatedRecord)record);
    }

    public boolean isAggregable(PortletUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.isAggregable(new AggregatedPortletUsageRecord(record));
        }
        catch (InvalidValueException e) {
            throw new NotAggregatableRecordsExceptions(e.getCause());
        }
    }

    @JsonIgnore
    public Class<PortletUsageRecord> getAggregable() {
        return PortletUsageRecord.class;
    }
}

