/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import java.util.SortedSet;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.basetypes.CalculateJobWallDurationAction;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.implementation.ComputedField;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmpty;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmptyIfNotNull;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

public abstract class AbstractJobUsageRecord
extends BasicUsageRecord {
    private static final long serialVersionUID = -8648691183939346858L;
    @RequiredField
    @NotEmpty
    public static final String JOB_ID = "jobId";
    @NotEmptyIfNotNull
    public static final String JOB_NAME = "jobName";
    @NotEmptyIfNotNull
    public static final String JOB_QUALIFIER = "jobQualifier";
    @RequiredField
    @ValidLong
    public static final String JOB_START_TIME = "jobStartTime";
    @RequiredField
    @ValidLong
    public static final String JOB_END_TIME = "jobEndTime";
    @RequiredField
    @ComputedField(action=CalculateJobWallDurationAction.class)
    @ValidLong
    public static final String DURATION = "duration";
    private static final String ABSTRACT_TO_REPLACE = "Abstract";

    public AbstractJobUsageRecord() {
    }

    public AbstractJobUsageRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    @Override
    public String getRecordType() {
        return AbstractJobUsageRecord.class.getSimpleName().replace(ABSTRACT_TO_REPLACE, "");
    }

    @Override
    public SortedSet<String> getQuerableKeys() throws Exception {
        SortedSet<String> properties = super.getQuerableKeys();
        properties.remove(JOB_START_TIME);
        properties.remove(JOB_END_TIME);
        return properties;
    }

    @JsonIgnore
    public String getJobId() {
        return (String)this.resourceProperties.get(JOB_ID);
    }

    @JsonIgnore
    public void setJobId(String jobId) throws InvalidValueException {
        this.setResourceProperty(JOB_ID, (Serializable)((Object)jobId));
    }

    @JsonIgnore
    public String getJobQualifier() {
        return (String)this.resourceProperties.get(JOB_QUALIFIER);
    }

    @JsonIgnore
    public void setJobQualifier(String jobQualifier) throws InvalidValueException {
        this.setResourceProperty(JOB_QUALIFIER, (Serializable)((Object)jobQualifier));
    }

    @JsonIgnore
    public String getJobName() {
        return (String)this.resourceProperties.get(JOB_NAME);
    }

    @JsonIgnore
    public void setJobName(String jobName) throws InvalidValueException {
        this.setResourceProperty(JOB_NAME, (Serializable)((Object)jobName));
    }

    @JsonIgnore
    public Calendar getJobStartTime() {
        long millis = (Long)this.resourceProperties.get(JOB_START_TIME);
        return AbstractJobUsageRecord.timestampToCalendar((long)millis);
    }

    @JsonIgnore
    public void setJobStartTime(Calendar jobStartTime) throws InvalidValueException {
        this.setResourceProperty(JOB_START_TIME, Long.valueOf(jobStartTime.getTimeInMillis()));
    }

    @JsonIgnore
    public Calendar getJobEndTime() {
        long millis = (Long)this.resourceProperties.get(JOB_END_TIME);
        return AbstractJobUsageRecord.timestampToCalendar((long)millis);
    }

    @JsonIgnore
    public void setJobEndTime(Calendar jobEndTime) throws InvalidValueException {
        this.setResourceProperty(JOB_END_TIME, Long.valueOf(jobEndTime.getTimeInMillis()));
    }

    protected long calculateDuration() throws InvalidValueException {
        try {
            long endTime = (Long)this.resourceProperties.get(JOB_END_TIME);
            long startTime = (Long)this.resourceProperties.get(JOB_START_TIME);
            long wallDuration = endTime - startTime;
            this.setResourceProperty(DURATION, Long.valueOf(wallDuration));
            return wallDuration;
        }
        catch (Exception e) {
            throw new InvalidValueException(String.format("To calculate Wall Duration both %s and %s must be set", JOB_START_TIME, JOB_END_TIME), (Throwable)e);
        }
    }

    @JsonIgnore
    public long getDuration() throws InvalidValueException {
        Long duration = (Long)this.resourceProperties.get(DURATION);
        if (duration == null) {
            duration = this.calculateDuration();
        }
        return duration;
    }

    @JsonIgnore
    public void setDuration(Long duration) throws InvalidValueException {
        this.setResourceProperty(DURATION, duration);
    }
}

