/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.utility.postgresql;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.documentstore.records.Record;

public class RecordToDBFields {
    protected final Class<? extends Record> clz;
    protected final String typeName;
    protected final String tableName;
    protected final Map<String, String> tableFieldToRecordField;
    protected final Map<String, String> recordFieldToTableField;

    public static String getKey(String fieldName) {
        StringBuffer stringBuffer = new StringBuffer();
        int lenght = fieldName.length();
        boolean lastLowerCase = false;
        for (int i = 0; i < lenght; ++i) {
            Character ch = Character.valueOf(fieldName.charAt(i));
            if (Character.isUpperCase(ch.charValue())) {
                if (lastLowerCase) {
                    stringBuffer.append("_");
                }
                lastLowerCase = false;
            } else {
                lastLowerCase = true;
            }
            stringBuffer.append(Character.toLowerCase(ch.charValue()));
        }
        return stringBuffer.toString();
    }

    protected RecordToDBFields(String typeName, Class<? extends Record> clz) throws Exception {
        this.clz = clz;
        this.typeName = typeName;
        this.tableName = RecordToDBFields.getKey(typeName);
        this.tableFieldToRecordField = new HashMap<String, String>();
        this.recordFieldToTableField = new HashMap<String, String>();
        this.mapFields();
    }

    protected void mapFields() throws Exception {
        Set requiredFields = this.clz.newInstance().getRequiredFields();
        for (String usageRecordField : requiredFields) {
            String dbField = RecordToDBFields.getKey(usageRecordField);
            this.tableFieldToRecordField.put(dbField, usageRecordField);
            this.recordFieldToTableField.put(usageRecordField, dbField);
        }
    }

    public String getTableField(String recordField) {
        return this.recordFieldToTableField.get(recordField);
    }

    public String getRecordField(String tableField) {
        String ret = this.tableFieldToRecordField.get(tableField);
        if (ret == null && this.recordFieldToTableField.keySet().contains(tableField)) {
            ret = tableField;
        }
        return ret;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTableName() {
        return this.tableName;
    }
}

