/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.service.rest;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")})
@Path(value="record")
public class RecordManagement {
    private static final Logger logger = LoggerFactory.getLogger(RecordManagement.class);
    public static final String RECORD_PATH_PART = "record";
    public static final String TYPE_PATH_PART = "type";
    public static final String RECORD_ID_PATH_PART = "recordID";

    @POST
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    public Response add(String json) throws Exception {
        InnerMethodName.set((String)"POST /record");
        logger.trace("Going to account : {}", (Object)json);
        AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
        List records = DSMapper.unmarshalList((String)json);
        for (Record record : records) {
            accountingPersistence.account(record);
        }
        logger.trace("{} accounted successfully", (Object)json);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }
}

