package org.gcube.accounting.service;

import java.util.Set;

import org.gcube.accounting.aggregator.RegexRulesAggregator;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class AccountingManager implements ApplicationManager {
	
	private static Logger logger = LoggerFactory.getLogger(AccountingManager.class);
	
	@Override
	public void onInit() {
		AuthorizationProvider authorizationProvider = ProviderFactory.provider().containerContext().authorizationProvider();
		Set<String> contexts = authorizationProvider.getContexts();
		logger.trace(
				"""
				-------------------------------------------------------
				Accouting Service is Starting in contexts {}
				-------------------------------------------------------""",
				contexts);


		try {
			for(String context : contexts) {
				try {
					Secret secret = authorizationProvider.getSecretForContext(context);
					SecretManagerProvider.set(secret);
					// Initializing the persistence connector used for insert
					AccountingPersistenceFactory.getPersistence();
					// Initializing the persistence connector used for query
					// AccountingPersistenceQueryFactory.getInstance();
					
					// Initializing RegexRulesAggregator
					RegexRulesAggregator.getInstance();

					logger.trace("""
						---------------------------------------------------
							Accounting Service successfully initialized
						---------------------------------------------------""");
					
					// The first working context is enough
					return;
				} catch (Exception e) {
					logger.error("Error while initializing Accounting Service using context {}. Trying another one", context, e);
				}
			}
		} finally {
			SecretManagerProvider.reset();
		}

	}
	
	public void onShutdown() {
		AuthorizationProvider authorizationProvider = ProviderFactory.provider().containerContext().authorizationProvider();
		Set<String> contexts = authorizationProvider.getContexts();

		logger.trace("""
			--------------------------------------
				Accounting Service is Stopping 
			--------------------------------------""");
		
		try {
			for(String context : contexts) {
					
				try {
					// Closing the persistence connector used for insert
					AccountingPersistenceFactory.getPersistence().close();
					
					// Closing the persistence connector used for query
					// AccountingPersistenceQueryFactory.getInstance().close();
					
					RegexRulesAggregator.getInstance().stop();
					
					logger.trace("""
						---------------------------------------------
							Accounting Service gracefully stopped 
						---------------------------------------------""");
					
					// The first working context is enough
					return;
				} catch(Exception e) {
					logger.error("Error while stopping Accounting Service in context {}. Trying another one", context, e);
				}
			}
		} finally {
			SecretManagerProvider.reset();
		}
		
	}
	
}
