/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.service.health;

import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.health.api.HealthCheck;
import org.gcube.common.health.api.ReadinessChecker;
import org.gcube.common.health.api.response.HealthCheckResponse;

@ReadinessChecker
public class InsertHealthCheck
implements HealthCheck {
    public static final String INSERT_CONNECTION_LABEL = "Insert Connection";
    private static final HealthCheckResponse UP = HealthCheckResponse.builder((String)"Insert Connection").up().build();
    private static final HealthCheckResponse DOWN = HealthCheckResponse.builder((String)"Insert Connection").down().error("Connection is not active").build();

    public String getName() {
        return INSERT_CONNECTION_LABEL;
    }

    public HealthCheckResponse check() {
        AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
        try {
            if (accountingPersistence.isConnectionActive()) {
                return UP;
            }
            return DOWN;
        }
        catch (Exception e) {
            return HealthCheckResponse.builder((String)this.getName()).down().error(e.getMessage()).build();
        }
    }
}

