

package org.gcube.accounting.usagetracker.rest.resources.reports;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.AggregatedResult;
import org.gcube.accounting.datamodel.reports.storagestatus.StorageStatusReport;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;
import org.joda.time.Period;

@Path("/reports/task")
public class TaskReports {
		
	private static Logger logger = Logger.getLogger(TaskReports.class);

	protected @Context HttpServletRequest request;


	
	@POST
	@Path("processors")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public Collection<AggregatedResult> getCountProcessorsReport(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getTaskCountProcessorsReport(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@POST
	@Path("worker-time")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public Collection<AggregatedResult> getWorkerTimeReport(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getTaskWorkerTimeReport(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@POST
	@Path("network-traffic")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public Collection<AggregatedResult> getNetworkTrafficReport(Report report) {
		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			if (report.getReportProperty().equals("rsp:overallNetworkIn"))
				return db.getTaskNetworkTrafficInputReport(report);
			else
				if(report.getReportProperty().equals("rsp:overallNetworkOut"))
				return db.getTaskNetworkTrafficOutputReport(report);
				else
					return new ArrayList<AggregatedResult>();
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	
	


}
