

package org.gcube.accounting.usagetracker.rest.resources.filters;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.AggregatedResult;
import org.gcube.accounting.datamodel.reports.aggregation.FilterRating;
import org.gcube.accounting.datamodel.reports.storagestatus.StorageStatusReport;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;
import org.joda.time.Period;

@Path("/filters/storage-status/")
public class StorageStatusFilters {
		
	private static Logger logger = Logger.getLogger(StorageStatusFilters.class);

	protected @Context HttpServletRequest request;


	@POST
	@Path("avg-volume")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public FilterRating getAvgVolumeFilter(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getStorageStatusAvgVolumeFilter(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@POST
	@Path("avg-entities")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public FilterRating getAvgEntitiesFilter(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getStorageStatusAvgEntitiesFilter(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@POST
	@Path("volume")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public FilterRating getVolumeFilter(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getStorageStatusVolumeFilter(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}
	
	@POST
	@Path("entities")
	//@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_XML)
	public FilterRating getEntitiesFilter(Report report) {

		try {
			UsageTrackerDB db = UsageTrackerDB.getStorage();
			return db.getStorageStatusEntitiesFilter(report);
		} catch (UnknownHostException e) {
			logger.error(e.getMessage(), e);
			throw new ServerErrorException(e.getMessage());
		}
	}

	
	


}
