/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.persistence;

import com.mongodb.DBObject;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

class Record {
    private static Logger logger = Logger.getLogger(Record.class);
    private String resourceOwner;
    private String consumerId;
    private String dataType;
    private String scope;
    private Long timestamp;
    private Double value;

    public Record(DBObject obj, String valueKey) throws Exception {
        DBObject idO = (DBObject)obj.get("_id");
        this.resourceOwner = idO.get("resourceOwner").toString();
        this.consumerId = idO.get("consumerId").toString();
        this.dataType = idO.get("rsp:dataType").toString();
        this.scope = idO.get("resourceScope").toString();
        this.value = Double.valueOf(obj.get(valueKey).toString());
        if (this.value < 0.0) {
            throw new Exception("Negative value found (" + this.value + "). Discarding");
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(11, 0);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        cal.set(5, Integer.valueOf(idO.get("day").toString()));
        cal.set(2, Integer.valueOf(idO.get("month").toString()) - 1);
        cal.set(1, Integer.valueOf(idO.get("year").toString()));
        this.timestamp = cal.getTimeInMillis();
        logger.debug((Object)("Record created with value " + this.getValue() + " and timestamp " + this.getTimestamp()));
    }

    public Record(String resourceOwner, String consumerId, String resourceType, String scope, Long timestamp, Double value) {
        this.resourceOwner = resourceOwner;
        this.consumerId = consumerId;
        this.dataType = resourceType;
        this.scope = scope;
        this.timestamp = timestamp;
        this.value = value;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getResourceOwner() {
        return this.resourceOwner;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public String getResourceType() {
        return this.dataType;
    }

    public String getScope() {
        return this.scope;
    }

    public Double getValue() {
        return this.value;
    }
}

