/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources.reports;

import java.net.UnknownHostException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.gcube.accounting.datamodel.reports.aggregation.AggregatedResult;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

@Path(value="/reports/job")
public class JobReports {
    private static Logger logger = Logger.getLogger(JobReports.class);
    @Context
    protected HttpServletRequest request;

    @POST
    @Path(value="jobs")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getCountJobsReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getJobCountJobsReport(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="elapsed-time")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getElapsedTimeReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getJobElapsedTimeReport(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }

    @POST
    @Path(value="net-elapsed-time")
    @Produces(value={"application/xml"})
    public Collection<AggregatedResult> getNetElapsedTimeReport(Report report) {
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            return db.getJobNetElapsedTimeReport(report);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
    }
}

