package org.gcube.accounting.usagetracker.persistence;


import com.mongodb.DBObject;
import com.mongodb.BasicDBObject;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.reports.Report;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

/**
 * MongoAggregatorHelper
 * 
 *
 * @author Ermanno Travaglino
 */

public class MongoAggregationHelper
{
	private static Logger logger = Logger.getLogger(MongoAggregationHelper.class);

	public static DBObject generateExistMatchClause (String filter, boolean exist) {
		logger.debug("Filter = "+filter);
		BasicDBObject matchClause = new BasicDBObject();
		matchClause.append(filter, new BasicDBObject("$exists", exist));
		DBObject match = new BasicDBObject("$match", matchClause);
		return match;
	}
	
	public static DBObject generateMatchClause(Report report){

		BasicDBObject matchClause = new BasicDBObject();
		matchClause.append("startTime", new BasicDBObject("$gte", report.getStartPeriod()).append("$lte", report.getEndPeriod()));
		matchClause.append("resourceType",report.getResourceType());
		if(report.getFilters() != null){
			Map<String,List<String>> filters =  report.getFilters();
			for (Map.Entry<String, List<String>> entry : filters.entrySet()) {
				if (entry!= null){
					String filterName = entry.getKey();
					List<String> filterValues = entry.getValue();
					matchClause.append(filterName, new BasicDBObject("$in", filterValues));
				}
			}
		}
		
		DBObject match = new BasicDBObject("$match", matchClause);
		logger.debug("match clause = "+matchClause);

		return match;
	}

	public static DBObject generateSortClause(Report report){

		BasicDBObject sortFields = new BasicDBObject();

		if(report.getAggregationGranule().toString().equals("week")){
			sortFields.append("_id.year", 1);
			sortFields.append("_id.week", 1);
		}
		else {
			if(report.getAggregationGranule().toString().equals("year")){
				sortFields.append("_id.year", 1);
			}
			else {
				if(report.getAggregationGranule().toString().equals("month")){
					sortFields.append("_id.year", 1);
					sortFields.append("_id.month", 1);
				}
				else {
					if(report.getAggregationGranule().toString().equals("day")){
						sortFields.append("_id.year", 1);
						sortFields.append("_id.month", 1);
						sortFields.append("_id.day", 1);
					}
				}
			}
		}

		BasicDBObject sort = new BasicDBObject("$sort", sortFields);

		logger.debug("final sort clause = "+sort);
		return sort;
	}
	
	public static DBObject generateDailyGroupClause(){
		BasicDBObject x = new BasicDBObject();
		x.put("resourceOwner", "$resourceOwner");
		x.put("resourceScope", "$resourceScope");
		x.put("resourceType","$resourceType");
		x.put("consumerId","$consumerId");
		x.put("rsp:dataType", "$rsp:dataType");
		x.put("year", new BasicDBObject("$year","$startTime"));
		x.put("month", new BasicDBObject("$month","$startTime"));
		x.put("day", new BasicDBObject("$dayOfMonth","$startTime"));
		DBObject groupClause = new BasicDBObject("_id",x);
		groupClause.put("rsp:dataVolume", new BasicDBObject("$last","$rsp:dataVolume"));
		groupClause.put("rsp:dataCount", new BasicDBObject("$last","$rsp:dataCount"));
		return groupClause;
	}
	
	public static DBObject generateGroupByDimensionClause(Report report) {
		BasicDBObject x = new BasicDBObject();
		
		if(report.getDimension() != null){
			x.put(report.getDimension(), "$_id." + report.getDimension());
		}
		x.put("year", "$_id.year");
		x.put("month", "$_id.month");
		x.put("day","$_id.day");
		DBObject groupClause = new BasicDBObject("_id",x);
		groupClause.put("rsp:dataVolume", new BasicDBObject("$sum","$rsp:dataVolume"));
		return groupClause;
	}

	public static DBObject generateGroupClause(Report report, boolean aggregationEnabled){
		BasicDBObject x = new BasicDBObject();
		x.put("resourceType","$resourceType");
		if(aggregationEnabled){
			if(report.getAggregationGranule().toString().equals("week")){
				x.put("year", new BasicDBObject("$year","$startTime"));
				x.put("week", new BasicDBObject("$week","$startTime"));
			}
			else
				if(report.getAggregationGranule().toString().equals("year")){
					x.put("year", new BasicDBObject("$year","$startTime"));
				}
				else
					if(report.getAggregationGranule().toString().equals("month")){
						x.put("year", new BasicDBObject("$year","$startTime"));
						x.put("month", new BasicDBObject("$month","$startTime"));

					}
					else
						if(report.getAggregationGranule().toString().equals("day")){
							x.put("year", new BasicDBObject("$year","$startTime"));
							x.put("month", new BasicDBObject("$month","$startTime"));
							x.put("day", new BasicDBObject("$dayOfMonth","$startTime"));

						}
		}
		x.put(report.getDimension(), "$"+report.getDimension());
		DBObject groupClause = new BasicDBObject("_id",x);
		return groupClause;
	}

	public static DateTime generateAggregationTime (DBObject idField, String granule){

		DateTime time = new DateTime(DateTimeZone.UTC).withTimeAtStartOfDay();

		if(granule.equals("week")){


			//logger.debug("week date == "+week + "-"+obj.toString());
			int year = (Integer) idField.get("year"); 
			time = time.withYear(year);//cal.set(Calendar.YEAR, year);

			int week = (Integer) idField.get("week");

			Calendar c = new GregorianCalendar();
			c.set(Calendar.WEEK_OF_YEAR, week);
			c.set(Calendar.YEAR, year);

			time = new DateTime(c).withTimeAtStartOfDay();

			//time = time.withWeekOfWeekyear(week);//cal.set(Calendar.WEEK_OF_YEAR, week);


			//logger.debug("time = "+time);
		}
		else
			if(granule.equals("year")){
				int year = (Integer) idField.get("year"); 
				time = time.withYear(year);//cal.set(Calendar.YEAR, year);
			}
			else
				if(granule.equals("month")){
					int year = (Integer) idField.get("year"); 
					time = time.withYear(year); //cal.set(Calendar.YEAR, year);
					int month = (Integer) idField.get("month"); 
					time = time.withMonthOfYear(month); //cal.set(Calendar.MONTH, month);
				}
				else
					if(granule.equals("day")){
						
						int day = (Integer) idField.get("day");
						int month = (Integer) idField.get("month"); 
						int year = (Integer) idField.get("year"); 
				
						//logger.debug("date === " +day+"/"+month+"/"+year);
						time = time.withYear(year);//cal.set(Calendar.YEAR, year);
						time = time.withMonthOfYear(month); //cal.set(Calendar.MONTH, month);
						time = time.withDayOfMonth(day); //cal.set(Calendar.DAY_OF_MONTH, day);
					}

		logger.debug("time = "+time);
		return time;

	}




}