/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.messaging.producer;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.ConnectionsManager;
import org.gcube.common.messaging.endpoints.BrokerNotConfiguredInScopeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Producer
implements Runnable {
    private static int ackMode;
    private static boolean transacted;
    private static String queueName;
    private static Producer singleton;
    private static Integer MAX_ACCOUNTING_QUEUE_SIZE;
    private static ConcurrentLinkedQueue<RawUsageRecord> messageForQueue;
    private static QueueConnection connection;
    private static Logger logger;

    private Producer() {
    }

    public synchronized void sendMessageToQueue(RawUsageRecord message) {
        String scope = message.getResourceScope();
        logger.debug("current scope = " + scope);
        try {
            ConnectionsManager.addScope(scope);
        }
        catch (BrokerNotConfiguredInScopeException e) {
            logger.debug("Exception sending message to the Broker");
            this.enqueueMessageForQueue(message);
        }
        catch (Exception e1) {
            logger.debug("Exception sending message to the Broker 2");
            this.enqueueMessageForQueue(message);
        }
        connection = ConnectionsManager.getQueueConnection(scope);
        logger.debug("CONNECTION = " + connection);
        if (connection == null) {
            ConnectionsManager.reloadConnection(scope);
        } else {
            try {
                QueueSession session = connection.createQueueSession(transacted, ackMode);
                logger.debug("session created");
                Queue queue = session.createQueue(scope + "." + queueName);
                logger.debug(connection.getClientID());
                logger.debug("accounting queue has been created");
                QueueSender sender = session.createSender(queue);
                sender.setDeliveryMode(2);
                ObjectMessage objMsg = session.createObjectMessage();
                objMsg.setObject((Serializable)message);
                objMsg.setJMSMessageID(this.createRandomString());
                sender.send((Message)objMsg);
                logger.debug("Message " + message.toString() + " SENT");
            }
            catch (JMSException e) {
                logger.debug("Exception sending message to the Broker");
                this.enqueueMessageForQueue(message);
            }
            catch (Exception e) {
                logger.debug("Exception sending message to the Broker");
                this.enqueueMessageForQueue(message);
            }
        }
    }

    private String createRandomString() {
        Random random = new Random(System.currentTimeMillis());
        long randomLong = random.nextLong();
        return Long.toHexString(randomLong);
    }

    public static Producer getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessageForQueue(RawUsageRecord message) {
        try {
            ConcurrentLinkedQueue<RawUsageRecord> concurrentLinkedQueue = messageForQueue;
            synchronized (concurrentLinkedQueue) {
                if (messageForQueue.size() >= MAX_ACCOUNTING_QUEUE_SIZE) {
                    logger.debug("Reached Maximum queue size, message discarded");
                    logger.debug(message.toString());
                } else {
                    messageForQueue.add(message);
                }
            }
        }
        catch (Exception e) {
            logger.debug("Error enqueuing Message : " + message.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int sizeQueue = 0;
        while (true) {
            ConcurrentLinkedQueue<RawUsageRecord> concurrentLinkedQueue = messageForQueue;
            synchronized (concurrentLinkedQueue) {
                sizeQueue = messageForQueue.size();
            }
            if (sizeQueue == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (sizeQueue <= 0) continue;
            RawUsageRecord message = null;
            ConcurrentLinkedQueue<RawUsageRecord> concurrentLinkedQueue2 = messageForQueue;
            synchronized (concurrentLinkedQueue2) {
                message = messageForQueue.poll();
            }
            this.sendMessageToQueue(message);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        queueName = "resource-accounting";
        MAX_ACCOUNTING_QUEUE_SIZE = 1000;
        messageForQueue = null;
        logger = LoggerFactory.getLogger(Producer.class);
        ackMode = 1;
        transacted = false;
        singleton = new Producer();
        messageForQueue = new ConcurrentLinkedQueue();
        Thread t = new Thread(singleton);
        t.start();
    }
}

