package org.gcube.accounting.messaging.consumer;
import java.util.ArrayList;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.accounting.datamodel.RawUsageRecord;
import org.gcube.accounting.messaging.QueueCouple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * JMS Client that receives message from ActiveMQ Broker
 * 
 * @author Andrea Manzi (CERN)
 * @author Ermanno Travaglino (E-IIS)
 *
 */

public class Consumer extends Thread implements ExceptionListener{

	private static Consumer singleton;

	//private static String url = "tcp://192.168.125.190:61616";//"tcp://message-broker.d.d4science.research-infrastructures.eu:6166?trace=true";
	protected static boolean transacted = false;
	protected static int ackMode = Session.AUTO_ACKNOWLEDGE;
	// Name of the queue we will receive messages from
	private static String subject = "resource-accounting";
	private static Logger logger = LoggerFactory.getLogger(Consumer.class);

	protected ArrayList<Connection> connections = new ArrayList<Connection>();

	protected QueueCouple queueCouple;


	static {

		singleton = new Consumer();

	}



	/**
	 * no object instantiation possible
	 */
	private Consumer() {}

	public static Consumer getSingleton() {
		return singleton;
	}



	/**
	 * Receives message from a QUEUE
	 * 	@param message the RawUsageRecord to send
	 */
	public RawUsageRecord receiveMessageFromQueue(QueueCouple queueCouple) {
		this.queueCouple = queueCouple;
		RawUsageRecord p = null;
		logger.debug("Receiving message from queue");
		ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(queueCouple.getBroker());
		Connection connection = null;
		while (connection == null){
			try{
				//Create Connection
				connection = connectionFactory.createConnection();
			}catch(JMSException e){          
				System.out.println("Error on subscription");
				try {
					Thread.sleep(6000 * 2);
				} catch (InterruptedException e1) {
					e1.printStackTrace();
				}
			}
		}
		

		logger.debug("Creating a new Connection");
		//Start/restart a connection
		try {
			connection.start();


			//Create Session
			Session session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
			//Create Queue
			Destination queue = session.createQueue(queueCouple.getScope()+"."+subject);
			//Create Consumer
			MessageConsumer consumer = session.createConsumer(queue);

			logger.debug("Consumer waiting...");

			//Consume Message. Call block until message is received or until close is called
			Message message = consumer.receive();
			logger.debug("new Message");

			if(message instanceof ObjectMessage){
				ObjectMessage obj = (ObjectMessage)message;
				p = (RawUsageRecord)obj.getObject();
				logger.debug("Received"+p.getId());   
			}else{
				logger.debug("Received message of unknown type");
			}
			consumer.close();
			session.close();
			connection.close();

		} catch (JMSException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return p;
	}

	public void run() {

		try {
			// reset previous connections;
			for (Connection connection : connections) {
				connection.stop();
				connection.close();
			}
			connections.clear();
		} catch (JMSException e) {
			logger.debug("Exception stopping the connection", e);
			connections.clear();
		}

		while (true) {
			try {
				this.subscribe();
				return;
			} catch (InvalidClientIDException ex) {
				logger.error("Subscription has not been reset", ex);
				return;

			} catch (Exception e) {
				logger.error("Error on subscription", e);
				try {
					Thread.sleep(6000 * 2);
				} catch (InterruptedException e1) {
					e1.printStackTrace();
				}
			}
		}
	}

	public void subscribe() throws Exception {
		receiveMessageFromQueue(queueCouple);
	}

	public void onException(JMSException exce) {
		logger.error(exce.getMessage());
		this.run();
	}






}