

package org.gcube.accounting.datamodel;

import java.util.Calendar;
import java.util.Map;

import org.gcube.accounting.exception.InvalidValueException;

public abstract class AbstractDelegateUsageRecord implements UsageRecord {

	protected UsageRecord ur;

	public AbstractDelegateUsageRecord() {
		this(new RawUsageRecord());
	}

	public AbstractDelegateUsageRecord(UsageRecord ur) {
		super();
		this.ur = ur;
	}

	public UsageRecord getDelegateUR() {
		return this.ur;
	}

	public Calendar getCreateTime() {
		return this.ur.getCreateTime();
	}

	public void setCreateTime(Calendar createTime) {
		this.ur.setCreateTime(createTime);
	}

//	public Calendar getModifyTime() {
//		return this.ur.getModifyTime();
//	}
//
//	public void setModifyTime(Calendar modifyTime) throws InvalidValueException {
//		this.ur.setModifyTime(modifyTime);
//	}

	public String getCreatorId() {
		return this.ur.getCreatorId();
	}

	public void setCreatorId(String creatorId) {
		this.ur.setCreatorId(creatorId);
	}

	public String getConsumerId() {
		return this.ur.getConsumerId();
	}

	public void setConsumerId(String consumerId) {
		this.ur.setConsumerId(consumerId);
	}

	public String getFullyQualifiedConsumerId() {
		return this.ur.getFullyQualifiedConsumerId();
	}

	public void setFullyQualifiedConsumerId(String fqcid) {
		this.ur.setFullyQualifiedConsumerId(fqcid);
	}	
	
	public Calendar getStartTime() {
		return this.ur.getStartTime();
	}

	public void setStartTime(Calendar startTime) throws InvalidValueException {
		this.ur.setStartTime(startTime);
	}

	public Calendar getEndTime() {
		return this.ur.getEndTime();
	}

	public void setEndTime(Calendar endTime) throws InvalidValueException {
		this.ur.setEndTime(endTime);
	}

	public String getId() {
		return this.ur.getId();
	}

	public void setId(String id) {
		this.ur.setId(id);
	}

	public String getResourceSpecificProperty(String name) {
		return this.ur.getResourceSpecificProperty(name);
	}

	public void setResourceSpecificProperty(String name, String value) {
		this.ur.setResourceSpecificProperty(name, value);
	}

//	public String getCustomProperty(String name) {
//		return this.ur.getCustomProperty(name);
//	}
//
//	public void setCustomProperty(String name, String value) {
//		this.ur.setCustomProperty(name, value);
//	}

	public Map<String, String> getResourceSpecificProperties() {
		return this.ur.getResourceSpecificProperties();
	}

	public void setResourceSpecificProperties(Map<String, String> props) {
		this.ur.setResourceSpecificProperties(props);
	}

//	public Map<String, String> getCustomProperties() {
//		return this.ur.getCustomProperties();
//	}
//
//	public void setCustomProperties(Map<String, String> props) {
//		this.ur.setCustomProperties(props);
//	}

	public String getAggregatedId() {
		return this.ur.getAggregatedId();
	}

	public void setAggregatedId(String aggregatedId) {
		this.ur.setAggregatedId(aggregatedId);
	}

	public String getResourceType() {
		return this.ur.getResourceType();
	}

	public void setResourceType(String resourceType) {
		this.ur.setResourceType(resourceType);
	}

	public String getResourceOwner() {
		return this.ur.getResourceOwner();
	}

	public void setResourceOwner(String owner) {
		this.ur.setResourceOwner(owner);
	}
	
	public void validate() throws InvalidValueException {
		if(this.getResourceOwner()==null)
			throw new InvalidValueException("field 'resourceOwner' is mandatory");
//		if(this.getConsumerId()==null)
//			throw new InvalidValueException("field 'consumerId' is mandatory");
		if(this.getStartTime()==null)
			throw new InvalidValueException("field 'startTime' is mandatory");
		if(this.getEndTime()==null)
			throw new InvalidValueException("field 'endTime' is mandatory");
		if(this.getResourceType()==null)
			throw new InvalidValueException("field 'resourceType' is mandatory");
	}

}
