/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.util.Map;
import java.util.TreeMap;
import org.ektorp.http.URI;
import org.ektorp.util.Assert;

public class UpdateHandlerRequest {
    private final Map<String, String> queryParams = new TreeMap<String, String>();
    private String dbPath;
    private String designDocId;
    private String functionName;
    private String docId;
    private Object body;

    public String getDbPath() {
        return this.dbPath;
    }

    public String getDesignDocId() {
        return this.designDocId;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Object getBody() {
        return this.body == null ? "" : this.body;
    }

    public UpdateHandlerRequest dbPath(String dbPath) {
        this.dbPath = dbPath;
        return this;
    }

    public UpdateHandlerRequest designDocId(String designDocId) {
        this.designDocId = designDocId;
        return this;
    }

    public UpdateHandlerRequest functionName(String functionName) {
        this.functionName = functionName;
        return this;
    }

    public UpdateHandlerRequest body(Object body) {
        this.body = body;
        return this;
    }

    public UpdateHandlerRequest param(String name, String value) {
        this.queryParams.put(name, value);
        return this;
    }

    public UpdateHandlerRequest params(Map<String, String> params) {
        if (params != null) {
            this.queryParams.putAll(params);
        }
        return this;
    }

    private URI buildUpdateHandlerRequestPath() {
        Assert.hasText(this.dbPath, "dbPath");
        Assert.hasText(this.functionName, "functionName");
        Assert.hasText(this.designDocId, "designDocId");
        Assert.hasText(this.docId, "docId");
        URI uri = URI.of(this.dbPath);
        uri.append(this.designDocId).append("_update").append(this.functionName).append(this.docId);
        return uri;
    }

    private void appendQueryParams(URI query) {
        for (Map.Entry<String, String> param : this.queryParams.entrySet()) {
            query.param(param.getKey(), param.getValue());
        }
    }

    public String buildRequestUri() {
        URI uri = this.buildUpdateHandlerRequestPath();
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            this.appendQueryParams(uri);
        }
        return uri.toString();
    }

    public String getDocId() {
        return this.docId;
    }

    public UpdateHandlerRequest docId(String docId) {
        this.docId = docId;
        return this;
    }
}

