/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.NullNode;
import org.ektorp.DbAccessException;
import org.ektorp.DocumentNotFoundException;
import org.ektorp.UpdateConflictException;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;

public class StdResponseHandler<T>
implements ResponseCallback<T> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static DbAccessException createDbAccessException(HttpResponse hr) {
        String body;
        JsonNode responseBody;
        try {
            responseBody = StdResponseHandler.responseBodyAsNode(IOUtils.toString(hr.getContent()));
        }
        catch (IOException e) {
            responseBody = NullNode.getInstance();
        }
        switch (hr.getCode()) {
            case 404: {
                return new DocumentNotFoundException(hr.getRequestURI(), responseBody);
            }
            case 409: {
                return new UpdateConflictException();
            }
        }
        try {
            body = StdResponseHandler.toPrettyString(responseBody);
        }
        catch (IOException e) {
            body = "unavailable";
        }
        return new DbAccessException(hr.toString() + "\nURI: " + hr.getRequestURI() + "\nResponse Body: \n" + body);
    }

    private static String toPrettyString(JsonNode n) throws IOException {
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(n);
    }

    private static JsonNode responseBodyAsNode(String s) throws IOException {
        if (s == null || s.length() == 0) {
            return NullNode.getInstance();
        }
        if (!s.startsWith("{")) {
            return NullNode.getInstance();
        }
        return MAPPER.readTree(s);
    }

    @Override
    public T error(HttpResponse hr) {
        throw StdResponseHandler.createDbAccessException(hr);
    }

    @Override
    public T success(HttpResponse hr) throws Exception {
        return null;
    }
}

