/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.exception.NoAvailableScopeException;
import org.gcube.accounting.analytics.exception.NoUsableAccountingPersistenceQueryFound;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryFactory;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRecordQuery {
    private static Logger logger = LoggerFactory.getLogger(ResourceRecordQuery.class);
    protected static Map<Class<? extends Record>, Set<String>> resourceRecords = null;
    protected AccountingPersistenceBackendQuery accountingPersistenceQuery = AccountingPersistenceBackendQueryFactory.getInstance();

    public static synchronized Map<Class<? extends Record>, Set<String>> getResourceRecordsTypes() {
        if (resourceRecords == null) {
            resourceRecords = new HashMap<Class<? extends Record>, Set<String>>();
            Collection resourceRecordsTypes = RecordUtility.getRecordClassesFound().values();
            for (Class resourceRecordsType : resourceRecordsTypes) {
                try {
                    Record record = (Record)resourceRecordsType.newInstance();
                    resourceRecords.put(resourceRecordsType, record.getRequiredFields());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    logger.error(String.format("Unable to correctly istantiate %s", resourceRecordsType.getSimpleName()), (Throwable)e);
                }
            }
        }
        return resourceRecords;
    }

    protected static JSONObject getPaddingJSONObject(Map<Calendar, Info> unpaddedResults) throws JSONException {
        Info auxInfo = new ArrayList<Info>(unpaddedResults.values()).get(0);
        JSONObject auxJsonObject = auxInfo.getValue();
        Iterator keys = auxJsonObject.keys();
        JSONObject jsonObject = new JSONObject();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            jsonObject.put(key, 0);
        }
        return jsonObject;
    }

    public static List<Info> getPaddedResults(Map<Calendar, Info> unpaddedData, TemporalConstraint temporalConstraint) throws Exception {
        JSONObject jsonObject = ResourceRecordQuery.getPaddingJSONObject(unpaddedData);
        ArrayList<Info> paddedResults = new ArrayList<Info>();
        List<Calendar> sequence = temporalConstraint.getCalendarSequence();
        for (Calendar progressTime : sequence) {
            if (unpaddedData.get(progressTime) != null) {
                paddedResults.add(unpaddedData.get(progressTime));
                continue;
            }
            Info info = new Info(progressTime, jsonObject);
            paddedResults.add(info);
        }
        return paddedResults;
    }

    public List<Info> getInfo(Class<? extends AggregatedRecord> usageRecordType, TemporalConstraint temporalConstraint, List<Filter> filters, boolean pad) throws Exception {
        Map<Calendar, Info> unpaddedResults = this.accountingPersistenceQuery.query(usageRecordType, temporalConstraint, filters);
        if (!pad) {
            return new ArrayList<Info>(unpaddedResults.values());
        }
        return ResourceRecordQuery.getPaddedResults(unpaddedResults, temporalConstraint);
    }

    public List<Info> getInfo(Class<? extends AggregatedRecord> usageRecordType, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        return this.getInfo(usageRecordType, temporalConstraint, filters, false);
    }

    public List<String> getKeys(Class<? extends AggregatedRecord> usageRecordType) throws Exception {
        Set<String> keys = this.accountingPersistenceQuery.getKeys(usageRecordType);
        ArrayList<String> toSort = new ArrayList<String>(keys);
        Collections.sort(toSort);
        return toSort;
    }

    public List<String> getPossibleValuesForKey(Class<? extends AggregatedRecord> usageRecordType, String key) throws Exception {
        Set<String> keys = this.accountingPersistenceQuery.getPossibleValuesForKey(usageRecordType, key);
        ArrayList<String> toSort = new ArrayList<String>(keys);
        Collections.sort(toSort);
        return toSort;
    }
}

