
function createInteractiveFilterLayerWFS(geoserverWfspath, workspace, layername, slidebarID, dateColumnName, startDateString, endDateString){

	var renderer = OpenLayers.Util.getParameters(window.location.href).renderer;
    renderer = (renderer) ? [renderer] : OpenLayers.Layer.Vector.prototype.renderers;
	
    var refresh = new OpenLayers.Strategy.Refresh({force: true, active: true});
    
	var startDateTimestamp = Date.parse(startDateString);
	var endDateTimestamp = Date.parse(endDateString);
	
	
    var filter = new OpenLayers.Filter.Comparison({
	    type: OpenLayers.Filter.Comparison.BETWEEN,
	    property: dateColumnName,
	    lowerBoundary: new Date(startDateTimestamp),
	    upperBoundary: new Date(endDateTimestamp)// new Date(startDate.getTime() + (parseInt(spanEl.value, 10) * 1000))
	});
    
    var filterStrategy = new OpenLayers.Strategy.Filter({ filter: filter});
	
	
	var wfsLayer = new OpenLayers.Layer.Vector("WFS", {
        strategies: [
                     new OpenLayers.Strategy.BBOX(),
                     new OpenLayers.Strategy.Cluster(),
                     refresh
        ],
        protocol: new OpenLayers.Protocol.WFS({
            url:  geoserverWfspath,
            featurePrefix: workspace,
            featureType: layername,
            geometryName: 'geom'
        }),
        styleMap: new OpenLayers.StyleMap({
            "default": new OpenLayers.Style({
                graphicName: "circle",
                pointRadius: "${radius}",
                fillOpacity: 0.8,
                fillColor: "#ffcc66",
                strokeColor: "#ff9933",
                strokeOpacity: 0.8,
                strokeWidth: 1
            },
            {
                context: {
                    radius: function(feature) {
                    	if(feature.attributes['count']==undefined) return 5;
                        return Math.min(feature.attributes.count, 30) + 4;
                    }
                }
            }),
            "select": new OpenLayers.Style({
                graphicName: "circle",
                pointRadius: "${radius}",
                fillOpacity: 0.8,
                fillColor: "#335CAD",
                strokeColor: "#002E8A",
                strokeOpacity: 0.8,
                strokeWidth: 1
            },
            {
                context: {
                    radius: function(feature) {
                    	if(feature.attributes['count']==undefined) return 5;
                        return Math.min(feature.attributes.count, 30) + 4;
                    }
                }
            })
        }),
	   	 filter: new OpenLayers.Filter.Comparison({
		    type: OpenLayers.Filter.Comparison.BETWEEN,
		    property: dateColumnName,
		    lowerBoundary: dateFilterReady(new Date(startDateTimestamp)),//"1900-01-20T12:11:50.501Z",
		    upperBoundary: dateFilterReady(new Date(endDateTimestamp))//"2011-01-20T12:11:50.501Z"
		}),
        renderers: renderer
    });
	

	
	wfsLayer.dateColumnName = dateColumnName;
	
	$(document.body).append("<div id='"+slidebarID+"container'></div>");
	$(document.body).append("<div id="+slidebarID+"></div>");
	
	
	var VisSelectID = slidebarID+"VisSel";
	var visSelHTML = "<select id='"+VisSelectID+"'><option value='nav'>Navigation</option><option value='vis'>Multiselect and Visualise</option></select>";
	if($("#"+VisSelectID).length==0){
		$(document.body).append(visSelHTML);
	}
	
	
	
//	var slider = $("#"+slidebarID);
	wfsLayer.slider = $("#"+slidebarID);
	
	var container = $("#"+slidebarID+"container");
	
	container.css("position","absolute"); //if this creates trouble, comment it out
	
	$(function() {
		wfsLayer.slider.slider({
			range : true,
			min : startDateTimestamp,
			max : endDateTimestamp,
			values : [startDateTimestamp, endDateTimestamp ],
			start: function(event,ui){
				($("#"+slidebarID)).slider().find(".ui-slider-handle").attr("title", "");
		    },
			slide : function(event, ui) {
				var lowDate = new Date(ui.values[0]);
				var highDate = new Date(ui.values[1]);
//				console.log("Low ts: "+ui.values[0]+"\tHigh ts"+ui.values[1]+"Low date: "+lowDate.toDateString()+"\tHigh date"+highDate.toDateString());			
		        ($("#"+slidebarID+" a:first")).tooltip({content:lowDate.toDateString(),track: true});
		        ($("#"+slidebarID+" a:last")).tooltip({content:highDate.toDateString(),track: true});
		        
			},
			stop: function(event,ui){
				($("#"+slidebarID)).slider().find(".ui-slider-handle").attr("title", "");
				var lowDate = new Date(ui.values[0]);
				var highDate = new Date(ui.values[1]);
				($("#"+slidebarID+" a:first")).tooltip();
		        ($("#"+slidebarID+" a:last")).tooltip();
		        wfsLayer.filter.lowerBoundary = dateFilterReady(lowDate);
		        wfsLayer.filter.upperBoundary = dateFilterReady(highDate);
		        refresh.refresh();
		    }
		});
		
		wfsLayer.slider.slider().find(".ui-slider-handle").attr("title", "");

	    ($("#"+slidebarID+" a:first")).tooltip({
		    content:(new Date(startDateTimestamp)).toDateString(),
			track: true
    	});
    
	    ($("#"+slidebarID+" a:last")).tooltip({
    		content:(new Date(endDateTimestamp)).toDateString(),
    		track: true
    	});
	    
	});
	
	
	$("#"+slidebarID).click(function(e) {e.stopPropagation();});
	$("#"+slidebarID).dblclick(function(e) {e.stopPropagation();});
	$("#"+slidebarID).mousedown(function(e) {e.stopPropagation();});
	
	$("#"+VisSelectID).click(function(e) {e.stopPropagation();});
	$("#"+VisSelectID).dblclick(function(e) {e.stopPropagation();});
	$("#"+VisSelectID).mousedown(function(e) {e.stopPropagation();});
	$("#"+VisSelectID).hide();
	
	
	$("#"+slidebarID+"container").append(document.getElementById(slidebarID));
	$("#"+slidebarID+"container").append(document.getElementById(VisSelectID));
	wfsLayer.div.appendChild(document.getElementById(slidebarID+"container"));
	
	
	
	wfsLayer.events.register("move",this,function(){
		var wPerc = 0.95; //width percentage
		var mapWidth = wfsLayer.map.getSize().w; //map width in pixels
		container.offset({"top":wfsLayer.slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
	});
	
	wfsLayer.events.register("moveend",this,function(){
		var wPerc = 0.95; //width percentage
		var mapWidth = wfsLayer.map.getSize().w; //map width in pixels
		container.offset({"top":wfsLayer.slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
	});
	
	
	wfsLayer.events.register("loadstart", this, function(){
		var wPerc = 0.95; //width percentage
		var mapWidth = wfsLayer.map.getSize().w; //map width in pixels
		container.offset({"top":wfsLayer.slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
		container.css('width', wPerc*mapWidth);
	});
	wfsLayer.events.register("loadend", this, function(){
		container.css("z-index",$("#layerSlidercontainer").parent().parent().css("z-index"));
		var wPerc = 0.95; //width percentage
		var mapWidth = wfsLayer.map.getSize().w; //map width in pixels
		container.offset({"top":wfsLayer.slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
		container.css('width', wPerc*mapWidth);
	});
	
	wfsLayer.getSliderValues = function(){
		return wfsLayer.slider.slider("option","values");
	};

	return wfsLayer;
}


function dateFilterReady(date){
	var month = String(date.getMonth()+1).length==1?"0"+String(date.getMonth()+1):String(date.getMonth()+1);
	var day = String(date.getDate()).length==1?"0"+String(date.getDate()):String(date.getDate());
	return date.getFullYear()+"-"+month+"-"+day+"T00:00:000Z";
}


