/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.CustomServlet;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBManager;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.Utils;
import org.gcube.application.framework.core.session.ASLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhylogenyServlet
extends CustomServlet {
    private static final Logger logger = LoggerFactory.getLogger(PhylogenyServlet.class);
    private static final long serialVersionUID = -873906383637717415L;

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String level = request.getParameter("phylogenyLevel");
        logger.trace("PhylogenyServlet-handleRequest level : " + level);
        if (level == null) {
            response.setStatus(400);
        } else {
            try {
                ASLSession session = Utils.getSession((HttpSession)request.getSession());
                try {
                    response.getWriter().write(DBManager.getInstance((String)session.getScope()).getPhylogenyJSON(level));
                    response.setStatus(200);
                }
                catch (Exception e) {
                    response.setStatus(500);
                    logger.trace("Exception while contacting service", (Throwable)e);
                }
            }
            catch (Exception e) {
                response.setStatus(401);
            }
        }
    }
}

