package org.gcube.application.aquamaps.aquamapsservice.client.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.aquamaps.aquamapsservice.client.Constants;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DefaultMaps;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.aquamapsservice.stubs.AquaMapsServicePortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.service.AquaMapsServiceAddressingLocator;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;

public class MapsPlugin extends AbstractPlugin<AquaMapsServicePortType,Maps> {

	public MapsPlugin() {
		super(Constants.NAMESPACE+"/aquamapsservice");
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public Maps newProxy(ProxyDelegate<AquaMapsServicePortType> delegate) {
		return new DefaultMaps(delegate);
	}

	@Override
	public AquaMapsServicePortType resolve(EndpointReferenceType address,
			ProxyConfig<?, ?> config) throws Exception {
		return new AquaMapsServiceAddressingLocator().getAquaMapsServicePortTypePort(address);
	}

	
	
}
