package org.gcube.application.aquamaps.aquamapsservice.client.proxies;

import java.io.File;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.List;

import org.gcube.application.aquamaps.aquamapsservice.stubs.DataManagementPortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GenerateMapsRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetGenerationLiveReportResponseType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ImportResourceRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.RemoveHSPECGroupGenerationRequestResponseType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.SetUserCustomQueryRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ViewCustomQueryRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.EnvironmentalExecutionReportItem;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.SourceGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.utils.RSWrapper;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.core.types.VOID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;

public class DefaultDataManagement implements DataManagement{

	private final ProxyDelegate<DataManagementPortType> delegate;
	
	public DefaultDataManagement(ProxyDelegate<DataManagementPortType> delegate) {
		this.delegate=delegate;
	}
	
	@Override
	public String analyzeTables(final Analysis request) throws RemoteException,
			Exception {
		Call<DataManagementPortType,String> call=new Call<DataManagementPortType, String>() {
			
			@Override
			public String call(DataManagementPortType endpoint) throws Exception {
				return endpoint.analyzeTables(request.toStubsVersion());
			}
		};
		return delegate.make(call);
	}
	
	
	@Override
	public String submitRequest(final SourceGenerationRequest request)
			throws RemoteException, Exception {
		Call<DataManagementPortType,String> call=new Call<DataManagementPortType, String>() {
			
			@Override
			public String call(DataManagementPortType endpoint) throws Exception {
				return endpoint.generateHSPECGroup(request.toStubsVersion());
			}
		};
		return delegate.make(call);
	}

	@Override
	public EnvironmentalExecutionReportItem getReport(final List<String> ids)
			throws RemoteException, Exception {
		Call<DataManagementPortType,EnvironmentalExecutionReportItem> call=new Call<DataManagementPortType, EnvironmentalExecutionReportItem>() {
			
			@Override
			public EnvironmentalExecutionReportItem call(DataManagementPortType endpoint)
					throws Exception {
				GetGenerationLiveReportResponseType report= endpoint.getGenerationLiveReportGroup(new StringArray(ids.toArray(new String[ids.size()])));
				return new EnvironmentalExecutionReportItem(report.getPercent(), report.getResourceLoad(), report.getResourceMap(), report.getElaboratedSpecies());
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public String getJSONSPECGroupGenreationRequests(
			final PagedRequestSettings settings) throws RemoteException, Exception {
		Call<DataManagementPortType,String> call=new Call<DataManagementPortType, String>() {
			
			@Override
			public String call(DataManagementPortType endpoint) throws Exception {
				return endpoint.getJSONSubmittedHSPECGroup(settings);
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public Integer generateMaps(String author, boolean enableGIS,
			Integer hspecId, List<Field> speciesFilter,
			boolean forceRegeneration) throws RemoteException, Exception {
		final GenerateMapsRequestType request= new GenerateMapsRequestType();
		request.setAuthor(author);
		request.setGenerateLayers(enableGIS);
		request.setHSPECId(hspecId);
		request.setSpeciesFilter(Field.toStubsVersion(speciesFilter));
		request.setForceRegeneration(forceRegeneration);
		Call<DataManagementPortType,Integer> call=new Call<DataManagementPortType, Integer>() {
			
			@Override
			public Integer call(DataManagementPortType endpoint) throws Exception {
				return endpoint.generateMaps(request);
			}
		};
		return delegate.make(call);
	}
	
	
	@Override
	public String removeRequest(String id, boolean deleteData,
			boolean deleteJobs) throws RemoteException, Exception {
		final RemoveHSPECGroupGenerationRequestResponseType request=new RemoveHSPECGroupGenerationRequestResponseType();
		request.setRequestId(id);
		request.setRemoveTables(deleteData);
		request.setRemoveJobs(deleteJobs);
		Call<DataManagementPortType,String> call=new Call<DataManagementPortType, String>() {
			
			@Override
			public String call(DataManagementPortType endpoint) throws Exception {
				endpoint.removeHSPECGroup(request);
				return "Done";
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public List<Field> getDefaultSources() throws RemoteException, Exception {
		Call<DataManagementPortType,List<Field>> call=new Call<DataManagementPortType, List<Field>>() {
			
			@Override
			public List<Field> call(DataManagementPortType pt) throws Exception {
				return Field.load(pt.getDefaultSources(new VOID()));
			}
		}; 
		return delegate.make(call);
	}
	
	
	@Override
	public Resource updateResource(final Resource toUpdate) throws RemoteException,
			Exception {
		Call<DataManagementPortType,Resource> call=new Call<DataManagementPortType, Resource>() {
			
			@Override
			public Resource call(DataManagementPortType pt) throws Exception {
				return new Resource(pt.editResource(toUpdate.toStubsVersion()));
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public void deleteResource(final int resourceId) throws RemoteException,
			Exception {
		Call<DataManagementPortType,Object> call=new Call<DataManagementPortType, Object>() {
			
			@Override
			public Object call(DataManagementPortType endpoint) throws Exception {
				endpoint.removeResource(resourceId);
				return null;
			}
		};
		delegate.make(call);
	}
	
	@Override
	public File exportResource(final int resourceId) throws RemoteException,
			Exception {
//		Call<DataManagementPortType,File> call=new Call<DataManagementPortType, File>() {
//			
//			@Override
//			public File call(DataManagementPortType endpoint) throws Exception {
//				String locator=endpoint.exportResource(resourceId);						
//				return RSWrapper.getStreamFromLocator(new URI(locator));	
//			}
//		};
//		return delegate.make(call);
		
		return null;
	}
	
	@Override
	public Boolean deleteCustomQuery(final String userId) throws RemoteException,
			Exception {
//		Call<DataManagementPortType,Boolean> call=new Call<DataManagementPortType, Boolean>() {
//			
//			@Override
//			public Boolean call(DataManagementPortType endpoint) throws Exception {				
//				return endpoint.deleteCustomQuery(userId);
//			}
//		};
//		
//		return delegate.make(call);
		
		return null;
	}
	
	@Override
	public void setCustomQuery(String userId, String queryString)
			throws RemoteException, Exception {
		final SetUserCustomQueryRequestType request=new SetUserCustomQueryRequestType(queryString, userId);
		Call<DataManagementPortType,Object> call=new Call<DataManagementPortType, Object>() {
			
			@Override
			public Object call(DataManagementPortType endpoint) throws Exception {
				endpoint.setCustomQuery(request);
				return null;
			}
		};
		delegate.make(call);
	}
	
	
	@Override
	public String viewCustomQuery(String userId, PagedRequestSettings settings)
			throws RemoteException, Exception {
		final ViewCustomQueryRequestType request=new ViewCustomQueryRequestType(settings, userId);
		
		Call<DataManagementPortType,String> call=new Call<DataManagementPortType, String>() {
			
			@Override
			public String call(DataManagementPortType endpoint) throws Exception {
				return endpoint.viewCustomQuery(request);
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public Integer getImportStatus(final Integer resourceId) throws RemoteException,
			Exception {
//		Call<DataManagementPortType,Integer> call=new Call<DataManagementPortType, Integer>() {
//			
//			@Override
//			public Integer call(DataManagementPortType endpoint) throws Exception {
//				return endpoint.getImportStatus(resourceId);
//			}
//		};
//		return delegate.make(call);
		
		return null;
	}
	
	
	@Override
	public Integer importResource(File toImport, String userId,
			ResourceType type, String encoding, boolean[] fieldsMask,
			boolean hasHeader, char delimiter) throws RemoteException,
			Exception {
//		RSWrapper wrapper=new RSWrapper(GCUBEScope.getScope(ScopeProvider.instance.get()));
//		wrapper.add(toImport);
//		String locator = wrapper.getLocator().toString();
//		final ImportResourceRequestType request=new ImportResourceRequestType(delimiter+"", encoding, fieldsMask, hasHeader, type+"", locator, userId);
//		Call<DataManagementPortType,Integer> call=new Call<DataManagementPortType, Integer>() {
//			
//			@Override
//			public Integer call(DataManagementPortType endpoint) throws Exception {
//				return endpoint.importResource(request);
//			}
//		};
//		return delegate.make(call);
		
		return null;
	}
	
	@Override
	public List<Field> getCustomQueryFields(final String userId)
			throws RemoteException, Exception {
//		Call<DataManagementPortType,List<Field>> call=new Call<DataManagementPortType, List<Field>>() {
//			
//			@Override
//			public List<Field> call(DataManagementPortType endpoint) throws Exception {
//				return Field.load(endpoint.isCustomQueryReady(userId));
//			}
//		};
//		return delegate.make(call);
		
		return null;
	}
	
	
	@Override
	public File exportTableAsCSV(final String table) throws RemoteException,
			Exception {
//		Call<DataManagementPortType,File> call=new Call<DataManagementPortType, File>() {
//			
//			@Override
//			public File call(DataManagementPortType endpoint) throws Exception {
//				String locator=endpoint.exportTableAsCSV(table);						
//				return RSWrapper.getStreamFromLocator(new URI(locator));	
//			}
//		};
//		return delegate.make(call);
		
		return null;
	}
	
	@Override
	public String getJsonSubmittedAnalysis(PagedRequestSettings settings)
			throws RemoteException, Exception {
		Call<DataManagementPortType,String> call=new Call<DataManagementPortType, String>() {
			
			@Override
			public String call(DataManagementPortType endpoint) throws Exception {
				// TODO Auto-generated method stub
				return null;
			}
		};
		return delegate.make(call);
	}
	
	
	@Override
	public File loadAnalysisResults(final String id) throws RemoteException,
			Exception {
		Call<DataManagementPortType,File> call=new Call<DataManagementPortType, File>() {
			
			@Override
			public File call(DataManagementPortType endpoint) throws Exception {
				String locator=endpoint.loadAnalysis(id);						
				return RSWrapper.getStreamFromLocator(new URI(locator));	
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public String resubmitGeneration(final String id) throws RemoteException,
			Exception {
		Call<DataManagementPortType,String> call=new Call<DataManagementPortType, String>() {
			
			@Override
			public String call(DataManagementPortType endpoint) throws Exception {
				return endpoint.resubmitGeneration(id);
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public File exportCurrentCustomQuery(final String userId) throws RemoteException,
			Exception {
//		Call<DataManagementPortType,File> call=new Call<DataManagementPortType, File>() {
//			
//			@Override
//			public File call(DataManagementPortType endpoint) throws Exception {
//				String locator=endpoint.exportCustomQuery(userId);						
//				return RSWrapper.getStreamFromLocator(new URI(locator));		
//			}
//		};
//		return delegate.make(call);
		
		return null;
	}
	
	@Override
	public void deleteAnalysis(final String id) throws RemoteException, Exception {
		Call<DataManagementPortType,Object> call=new Call<DataManagementPortType, Object>() {
			
			@Override
			public Object call(DataManagementPortType endpoint) throws Exception {
				endpoint.deleteAnalysis(id);
				return null;
			}
		};
		delegate.make(call);
	}
	
}
