/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.BoundingBox;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.DataModel;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.EnvelopeFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.HspenFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.collections.FieldArray;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;

public class Envelope
extends DataModel {
    private boolean useFaoAreas = true;
    private boolean useBoundingBox = true;
    private boolean useBottomSeaTempAndSalinity = true;
    private String FaoAreas = "";
    private BoundingBox boundingBox = new BoundingBox();
    private boolean pelagic;
    private boolean useMeanDepth;
    private Map<EnvelopeFields, Map<HspenFields, Double>> parameters = new HashMap<EnvelopeFields, Map<HspenFields, Double>>();

    public boolean isUseFaoAreas() {
        return this.useFaoAreas;
    }

    public void setUseFaoAreas(boolean useFaoAreas) {
        this.useFaoAreas = useFaoAreas;
    }

    public boolean isUseBoundingBox() {
        return this.useBoundingBox;
    }

    public void setUseBoundingBox(boolean useBoundingBox) {
        this.useBoundingBox = useBoundingBox;
    }

    public boolean isUseBottomSeaTempAndSalinity() {
        return this.useBottomSeaTempAndSalinity;
    }

    public void setUseBottomSeaTempAndSalinity(boolean useBottomSeaTempAndSalinity) {
        this.useBottomSeaTempAndSalinity = useBottomSeaTempAndSalinity;
    }

    public String getFaoAreas() {
        return this.FaoAreas;
    }

    public void setFaoAreas(String faoAreas) {
        this.FaoAreas = faoAreas;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public boolean isPelagic() {
        return this.pelagic;
    }

    public void setPelagic(boolean pelagic) {
        this.pelagic = pelagic;
    }

    public Envelope() {
        HashMap<HspenFields, Double> depth = new HashMap<HspenFields, Double>();
        depth.put(HspenFields.depthmin, new Double(0.0));
        depth.put(HspenFields.depthmax, new Double(0.0));
        depth.put(HspenFields.depthprefmax, new Double(0.0));
        depth.put(HspenFields.depthprefmin, new Double(0.0));
        this.parameters.put(EnvelopeFields.Depth, depth);
        HashMap<HspenFields, Double> temp = new HashMap<HspenFields, Double>();
        temp.put(HspenFields.tempmin, new Double(0.0));
        temp.put(HspenFields.tempmax, new Double(0.0));
        temp.put(HspenFields.tempprefmax, new Double(0.0));
        temp.put(HspenFields.tempprefmin, new Double(0.0));
        this.parameters.put(EnvelopeFields.Temperature, temp);
        HashMap<HspenFields, Double> salinity = new HashMap<HspenFields, Double>();
        salinity.put(HspenFields.salinitymin, new Double(0.0));
        salinity.put(HspenFields.salinitymax, new Double(0.0));
        salinity.put(HspenFields.salinityprefmax, new Double(0.0));
        salinity.put(HspenFields.salinityprefmin, new Double(0.0));
        this.parameters.put(EnvelopeFields.Salinity, salinity);
        HashMap<HspenFields, Double> primProd = new HashMap<HspenFields, Double>();
        primProd.put(HspenFields.primprodprefmin, new Double(0.0));
        primProd.put(HspenFields.primprodprefmax, new Double(0.0));
        primProd.put(HspenFields.primprodmin, new Double(0.0));
        primProd.put(HspenFields.primprodmax, new Double(0.0));
        this.parameters.put(EnvelopeFields.PrimaryProduction, primProd);
        HashMap<HspenFields, Double> iceCon = new HashMap<HspenFields, Double>();
        iceCon.put(HspenFields.iceconmin, new Double(0.0));
        iceCon.put(HspenFields.iceconmax, new Double(0.0));
        iceCon.put(HspenFields.iceconprefmin, new Double(0.0));
        iceCon.put(HspenFields.iceconprefmax, new Double(0.0));
        this.parameters.put(EnvelopeFields.IceConcentration, iceCon);
        HashMap<HspenFields, Double> land = new HashMap<HspenFields, Double>();
        land.put(HspenFields.landdistmin, new Double(0.0));
        land.put(HspenFields.landdistmax, new Double(0.0));
        land.put(HspenFields.landdistprefmin, new Double(0.0));
        land.put(HspenFields.landdistprefmax, new Double(0.0));
        this.parameters.put(EnvelopeFields.LandDistance, land);
    }

    public Set<HspenFields> getValueNames(EnvelopeFields parameterName) {
        return this.parameters.get((Object)parameterName).keySet();
    }

    public Double getValue(EnvelopeFields parameterName, HspenFields depthprefmax) {
        return this.parameters.get((Object)parameterName).get((Object)depthprefmax);
    }

    public void setValue(EnvelopeFields parameterName, HspenFields valueName, double d) {
        this.parameters.get((Object)parameterName).put(valueName, new Double(d));
    }

    public Double getMinValue(EnvelopeFields parameter) {
        switch (parameter) {
            case Depth: {
                return this.getValue(parameter, HspenFields.depthmin);
            }
            case IceConcentration: {
                return this.getValue(parameter, HspenFields.iceconmin);
            }
            case LandDistance: {
                return this.getValue(parameter, HspenFields.landdistmin);
            }
            case PrimaryProduction: {
                return this.getValue(parameter, HspenFields.primprodmin);
            }
            case Salinity: {
                return this.getValue(parameter, HspenFields.salinitymin);
            }
            case Temperature: {
                return this.getValue(parameter, HspenFields.tempmin);
            }
        }
        throw new IllegalArgumentException();
    }

    public static HspenFields getMinName(EnvelopeFields parameter) {
        switch (parameter) {
            case Depth: {
                return HspenFields.depthmin;
            }
            case IceConcentration: {
                return HspenFields.iceconmin;
            }
            case LandDistance: {
                return HspenFields.landdistmin;
            }
            case PrimaryProduction: {
                return HspenFields.primprodmin;
            }
            case Salinity: {
                return HspenFields.salinitymin;
            }
            case Temperature: {
                return HspenFields.tempmin;
            }
        }
        throw new IllegalArgumentException();
    }

    public Double getMaxValue(EnvelopeFields parameter) {
        switch (parameter) {
            case Depth: {
                return this.getValue(parameter, HspenFields.depthmax);
            }
            case IceConcentration: {
                return this.getValue(parameter, HspenFields.iceconmax);
            }
            case LandDistance: {
                return this.getValue(parameter, HspenFields.landdistmax);
            }
            case PrimaryProduction: {
                return this.getValue(parameter, HspenFields.primprodmax);
            }
            case Salinity: {
                return this.getValue(parameter, HspenFields.salinitymax);
            }
            case Temperature: {
                return this.getValue(parameter, HspenFields.tempmax);
            }
        }
        throw new IllegalArgumentException();
    }

    public static HspenFields getMaxName(EnvelopeFields parameter) {
        switch (parameter) {
            case Depth: {
                return HspenFields.depthmax;
            }
            case IceConcentration: {
                return HspenFields.iceconmax;
            }
            case LandDistance: {
                return HspenFields.landdistmax;
            }
            case PrimaryProduction: {
                return HspenFields.primprodmax;
            }
            case Salinity: {
                return HspenFields.salinitymax;
            }
            case Temperature: {
                return HspenFields.tempmax;
            }
        }
        throw new IllegalArgumentException();
    }

    public Double getPrefMinValue(EnvelopeFields parameter) {
        switch (parameter) {
            case Depth: {
                return this.getValue(parameter, HspenFields.depthprefmin);
            }
            case IceConcentration: {
                return this.getValue(parameter, HspenFields.iceconprefmin);
            }
            case LandDistance: {
                return this.getValue(parameter, HspenFields.landdistprefmin);
            }
            case PrimaryProduction: {
                return this.getValue(parameter, HspenFields.primprodprefmin);
            }
            case Salinity: {
                return this.getValue(parameter, HspenFields.salinityprefmin);
            }
            case Temperature: {
                return this.getValue(parameter, HspenFields.tempprefmin);
            }
        }
        throw new IllegalArgumentException();
    }

    public static HspenFields getPrefMinName(EnvelopeFields parameter) {
        switch (parameter) {
            case Depth: {
                return HspenFields.depthprefmin;
            }
            case IceConcentration: {
                return HspenFields.iceconprefmin;
            }
            case LandDistance: {
                return HspenFields.landdistprefmin;
            }
            case PrimaryProduction: {
                return HspenFields.primprodprefmin;
            }
            case Salinity: {
                return HspenFields.salinityprefmin;
            }
            case Temperature: {
                return HspenFields.tempprefmin;
            }
        }
        throw new IllegalArgumentException();
    }

    public Double getPrefMaxValue(EnvelopeFields parameter) {
        switch (parameter) {
            case Depth: {
                return this.getValue(parameter, HspenFields.depthprefmax);
            }
            case IceConcentration: {
                return this.getValue(parameter, HspenFields.iceconprefmax);
            }
            case LandDistance: {
                return this.getValue(parameter, HspenFields.landdistprefmax);
            }
            case PrimaryProduction: {
                return this.getValue(parameter, HspenFields.primprodprefmax);
            }
            case Salinity: {
                return this.getValue(parameter, HspenFields.salinityprefmax);
            }
            case Temperature: {
                return this.getValue(parameter, HspenFields.tempprefmax);
            }
        }
        throw new IllegalArgumentException();
    }

    public static HspenFields getPrefMaxName(EnvelopeFields parameter) {
        switch (parameter) {
            case Depth: {
                return HspenFields.depthprefmax;
            }
            case IceConcentration: {
                return HspenFields.iceconprefmax;
            }
            case LandDistance: {
                return HspenFields.landdistprefmax;
            }
            case PrimaryProduction: {
                return HspenFields.primprodprefmax;
            }
            case Salinity: {
                return HspenFields.salinityprefmax;
            }
            case Temperature: {
                return HspenFields.tempprefmax;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setUseMeanDepth(boolean useMeanDepth) {
        this.useMeanDepth = useMeanDepth;
    }

    public boolean isUseMeanDepth() {
        return this.useMeanDepth;
    }

    public FieldArray toFieldArray() {
        ArrayList<Field> fields = new ArrayList<Field>();
        EnvelopeFields[] envelopeFieldsArray = EnvelopeFields.values();
        int n = envelopeFieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnvelopeFields envF = envelopeFieldsArray[n2];
            for (HspenFields paramName : this.getValueNames(envF)) {
                Field f = new Field();
                f.name(paramName.toString());
                f.type(FieldType.DOUBLE);
                f.value(String.valueOf(this.getValue(envF, paramName)));
                fields.add(f);
            }
            ++n2;
        }
        return new FieldArray(fields);
    }
}

