/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.CustomQueryDescriptorFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.collections.FieldArray;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ExportStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
public class CustomQueryDescriptorStubs {
    private static Logger logger = LoggerFactory.getLogger(CustomQueryDescriptorStubs.class);
    @XmlElement
    private String user = "";
    @XmlElement
    private Long rows = 0L;
    @XmlElement
    private FieldArray fields = new FieldArray();
    @XmlElement
    private ExportStatus status = ExportStatus.PENDING;
    @XmlElement
    private String errorMsg = "";
    @XmlElement
    private String actualTableName;
    @XmlElement
    private String query = "";
    @XmlElement
    private Long creationTime = 0L;
    @XmlElement
    private Long lastAccess = 0L;

    public CustomQueryDescriptorStubs() {
    }

    public String user() {
        return this.user;
    }

    public void user(String user) {
        this.user = user;
    }

    public Long rows() {
        return this.rows;
    }

    public void rows(Long rows) {
        this.rows = rows;
    }

    public FieldArray fields() {
        return this.fields;
    }

    public void fields(FieldArray fields) {
        this.fields = fields;
    }

    public ExportStatus status() {
        return this.status;
    }

    public void status(ExportStatus status) {
        this.status = status;
    }

    public String errorMessage() {
        return this.errorMsg;
    }

    public void errorMessage(String errorMessage) {
        this.errorMsg = errorMessage;
    }

    public String actualTableName() {
        return this.actualTableName;
    }

    public void actualTableName(String actualTableName) {
        this.actualTableName = actualTableName;
    }

    public String query() {
        return this.query;
    }

    public void query(String query) {
        this.query = query;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public void creationTime(Long creationTime) {
        this.creationTime = creationTime;
    }

    public Long lastAccess() {
        return this.lastAccess;
    }

    public void lastAccess(Long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CustomQueryDescriptorStubs [user=");
        builder.append(this.user);
        builder.append(", rows=");
        builder.append(this.rows);
        builder.append(", fields=");
        builder.append(this.fields);
        builder.append(", status=");
        builder.append((Object)this.status);
        builder.append(", errorMsg=");
        builder.append(this.errorMsg);
        builder.append(", actualTableName=");
        builder.append(this.actualTableName);
        builder.append(", query=");
        builder.append(this.query);
        builder.append(", creationTime=");
        builder.append(this.creationTime);
        builder.append(", lastAccess=");
        builder.append(this.lastAccess);
        builder.append("]");
        return builder.toString();
    }

    public static ArrayList<CustomQueryDescriptorStubs> loadResultSet(ResultSet rs) throws Exception {
        ArrayList<CustomQueryDescriptorStubs> toReturn = new ArrayList<CustomQueryDescriptorStubs>();
        while (rs.next()) {
            toReturn.add(new CustomQueryDescriptorStubs(Field.loadRow(rs)));
        }
        return toReturn;
    }

    public CustomQueryDescriptorStubs(ResultSet rs) throws Exception {
        this(Field.loadRow(rs));
    }

    public CustomQueryDescriptorStubs(List<Field> row) {
        for (Field f : row) {
            try {
                this.setField(f);
            }
            catch (Exception e) {}
        }
    }

    public boolean setField(Field f) throws JSONException {
        try {
            switch (CustomQueryDescriptorFields.valueOf(f.name().toLowerCase())) {
                case count: {
                    this.rows(f.getValueAsLong());
                    break;
                }
                case creationtime: {
                    this.creationTime(f.getValueAsLong());
                    break;
                }
                case errors: {
                    this.errorMessage(f.value());
                    break;
                }
                case fields: {
                    this.fields((FieldArray)AquaMapsXStream.getXMLInstance().fromXML(f.value()));
                    break;
                }
                case lastaccess: {
                    this.lastAccess(f.getValueAsLong());
                    break;
                }
                case query: {
                    this.query(f.value());
                    break;
                }
                case resulttable: {
                    this.actualTableName(f.value());
                    break;
                }
                case status: {
                    this.status(ExportStatus.valueOf(f.value()));
                    break;
                }
                case userid: {
                    this.user(f.value());
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to parse field " + f.toJSONObject(), (Throwable)e);
        }
        return true;
    }

    public Field getField(CustomQueryDescriptorFields fieldName) {
        switch (fieldName) {
            case count: {
                return new Field((Object)((Object)fieldName) + "", this.rows() + "", FieldType.LONG);
            }
            case creationtime: {
                return new Field((Object)((Object)fieldName) + "", this.creationTime() + "", FieldType.LONG);
            }
            case errors: {
                return new Field((Object)((Object)fieldName) + "", this.errorMessage(), FieldType.STRING);
            }
            case fields: {
                return new Field((Object)((Object)fieldName) + "", AquaMapsXStream.getXMLInstance().toXML(this.fields()), FieldType.STRING);
            }
            case lastaccess: {
                return new Field((Object)((Object)fieldName) + "", this.lastAccess() + "", FieldType.LONG);
            }
            case query: {
                return new Field((Object)((Object)fieldName) + "", this.query(), FieldType.STRING);
            }
            case resulttable: {
                return new Field((Object)((Object)fieldName) + "", this.actualTableName(), FieldType.STRING);
            }
            case status: {
                return new Field((Object)((Object)fieldName) + "", (Object)((Object)this.status()) + "", FieldType.STRING);
            }
            case userid: {
                return new Field((Object)((Object)fieldName) + "", this.user(), FieldType.STRING);
            }
        }
        return null;
    }

    public List<Field> toRow() throws JSONException {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        for (CustomQueryDescriptorFields f : CustomQueryDescriptorFields.values()) {
            toReturn.add(this.getField(f));
        }
        return toReturn;
    }
}

