/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads.QueryConstructurThread;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.CustomQueryDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Filter;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.CustomQueryDescriptorFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FilterType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;

public class CustomQueryManager {
    public static final String userQueryTable = "userqueries";
    private static final GCUBELog logger = new GCUBELog(CustomQueryManager.class);

    public static String setUserCustomQuery(String user, String queryString) throws Exception {
        DBSession session = null;
        try {
            CustomQueryManager.deleteUserQuery(user);
            session = DBSession.getInternalDBSession();
            String tableName = ServiceUtils.generateId("CUSTOM", "").toLowerCase();
            logger.trace((Object)"Inserting reference on table..");
            CustomQueryDescriptor toInsert = new CustomQueryDescriptor();
            toInsert.setActualTableName(tableName);
            toInsert.setCreationTime(Long.valueOf(System.currentTimeMillis()));
            toInsert.setQuery(queryString);
            toInsert.setUser(user);
            toInsert.setLastAccess(Long.valueOf(System.currentTimeMillis()));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(toInsert.toRow());
            session.insertOperation(userQueryTable, rows);
            QueryConstructurThread t = new QueryConstructurThread(user, QueryConstructurThread.Operation.CREATE, queryString, tableName);
            t.start();
            String string = user;
            return string;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String getPagedResult(String user, PagedRequestSettings settings) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            CustomQueryManager.updateLastAccessTime(user);
            CustomQueryDescriptor desc = CustomQueryManager.getDescriptor(user);
            String query = "SELECT * from " + desc.getActualTableName() + " ORDER BY " + settings.getOrderField() + " " + settings.getOrderDirection() + " LIMIT " + settings.getLimit() + " OFFSET " + settings.getOffset();
            String string = DBUtils.toJSon(session.executeQuery(query), desc.getRows());
            return string;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static int deleteUserQuery(String user) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            CustomQueryDescriptor desc = CustomQueryManager.getDescriptor(user);
            QueryConstructurThread t = new QueryConstructurThread(user, QueryConstructurThread.Operation.DELETE, desc.getQuery(), desc.getActualTableName());
            t.start();
            logger.trace((Object)("Deleting " + user + "'s custom query reference"));
            ArrayList<Field> field = new ArrayList<Field>();
            field.add(desc.getField(CustomQueryDescriptorFields.userid));
            int n = session.deleteOperation(userQueryTable, field);
            return n;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static void updateLastAccessTime(String userId) throws Exception {
        DBSession session = null;
        try {
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            keys.add(new ArrayList<Field>(Arrays.asList(new Field("" + CustomQueryDescriptorFields.userid, userId, FieldType.STRING))));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(new ArrayList<Field>(Arrays.asList(new Field("" + CustomQueryDescriptorFields.lastaccess, String.valueOf(System.currentTimeMillis()), FieldType.LONG))));
            session = DBSession.getInternalDBSession();
            if (session.updateOperation(userQueryTable, keys, rows) == 0) {
                throw new Exception("No custom query reference found for user " + userId);
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static int clean() throws Exception {
        DBSession session = null;
        try {
            int keepAliveMinutes = ServiceContext.getContext().getPropertyAsInteger("CUSTOM_QUERY_KEEP_ALIVE_MINUTES");
            Filter timeFilter = new Filter(FilterType.smaller_then, new Field("" + CustomQueryDescriptorFields.lastaccess, String.valueOf(System.currentTimeMillis() - (long)(keepAliveMinutes * 1000 * 60)), FieldType.LONG));
            String queryString = "SELECT * FROM userqueries WHERE " + CustomQueryDescriptorFields.lastaccess + " " + timeFilter.toSQLString();
            session = DBSession.getInternalDBSession();
            ResultSet rs = session.executeQuery(queryString);
            int count = 0;
            while (rs.next()) {
                String user = rs.getString("" + CustomQueryDescriptorFields.userid);
                try {
                    count += CustomQueryManager.deleteUserQuery(user);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to delete custom query for user " + user), (Throwable)e);
                }
            }
            int n = count;
            return n;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static CustomQueryDescriptor getDescriptor(String userid) throws Exception {
        DBSession session = null;
        try {
            CustomQueryManager.updateLastAccessTime(userid);
            session = DBSession.getInternalDBSession();
            ArrayList<Field> field = new ArrayList<Field>();
            field.add(new Field("" + CustomQueryDescriptorFields.userid, userid, FieldType.STRING));
            ResultSet rs = session.executeFilteredQuery(field, userQueryTable, "" + CustomQueryDescriptorFields.userid, OrderDirection.ASC);
            if (rs.next()) {
                CustomQueryDescriptor customQueryDescriptor = new CustomQueryDescriptor(rs);
                return customQueryDescriptor;
            }
            throw new Exception("Custom Query Not Found for user " + userid);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static int updateDescriptor(CustomQueryDescriptor desc) throws Exception {
        DBSession session = null;
        try {
            desc.setLastAccess(Long.valueOf(System.currentTimeMillis()));
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(desc.getField(CustomQueryDescriptorFields.userid));
            keys.add(key);
            ArrayList<Field> row = new ArrayList<Field>();
            CustomQueryDescriptorFields[] customQueryDescriptorFieldsArray = CustomQueryDescriptorFields.values();
            int n = customQueryDescriptorFieldsArray.length;
            int n2 = 0;
            while (n2 < n) {
                CustomQueryDescriptorFields f = customQueryDescriptorFieldsArray[n2];
                if (!f.equals((Object)CustomQueryDescriptorFields.userid)) {
                    row.add(desc.getField(f));
                }
                ++n2;
            }
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(row);
            int n3 = session.updateOperation(userQueryTable, keys, rows);
            return n3;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

