/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.SourceGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SourceGenerationRequestFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SourceGenerationPhase;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;

public class SourceGenerationRequestsManager {
    private static final GCUBELog logger = new GCUBELog(SourceGenerationRequestsManager.class);
    public static final String requestsTable = "source_generation_requests";

    public static String insertRequest(SourceGenerationRequest toInsert) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            toInsert.setId(ServiceUtils.generateId("HGGR", ""));
            toInsert.setPhase(SourceGenerationPhase.pending);
            toInsert.setSubmissiontime(Long.valueOf(System.currentTimeMillis()));
            toInsert.setGeneratedSources(new ArrayList());
            toInsert.setJobIds(new ArrayList());
            toInsert.setCurrentphasepercent(Double.valueOf(0.0));
            toInsert.setEndtime(Long.valueOf(0L));
            toInsert.setEvaluatedComputationCount(Integer.valueOf(0));
            toInsert.setReportID(new ArrayList());
            toInsert.setStarttime(Long.valueOf(0L));
            toInsert.setToGenerateTableCount(Integer.valueOf(0));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> toInsertRow = new ArrayList<Field>();
            logger.debug((Object)"Inserting request, fields are :");
            for (Field f : toInsert.toRow()) {
                if (f.getValue() == null || f.getValue().equalsIgnoreCase("null")) continue;
                toInsertRow.add(f);
                logger.debug((Object)f.toXML());
            }
            rows.add(toInsertRow);
            session.insertOperation(requestsTable, rows);
            String string = toInsert.getId();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static void updateField(String id, List<Field> values) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field("" + SourceGenerationRequestFields.id, id, FieldType.STRING));
            keys.add(key);
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(values);
            session.updateOperation(requestsTable, keys, rows);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static ArrayList<SourceGenerationRequest> getList(ArrayList<Field> filter) throws Exception {
        DBSession session = null;
        if (filter == null) {
            filter = new ArrayList();
        }
        try {
            session = DBSession.getInternalDBSession();
            ArrayList arrayList = SourceGenerationRequest.loadResultSet((ResultSet)session.executeFilteredQuery(filter, requestsTable, "" + SourceGenerationRequestFields.submissiontime, OrderDirection.ASC));
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<SourceGenerationRequest> getList(List<Field> filter, PagedRequestSettings settings) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<SourceGenerationRequest> toReturn = new ArrayList<SourceGenerationRequest>();
            ResultSet rs = session.executeFilteredQuery(filter, requestsTable, settings.getOrderField(), settings.getOrderDirection());
            int rowIndex = 0;
            while (rs.next() && toReturn.size() < settings.getLimit()) {
                if (rowIndex >= settings.getOffset()) {
                    toReturn.add(new SourceGenerationRequest(rs));
                }
                ++rowIndex;
            }
            ArrayList<SourceGenerationRequest> arrayList = toReturn;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Field getField(String id, String field) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setPhase(SourceGenerationPhase phase, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("" + SourceGenerationRequestFields.phase, "" + phase, FieldType.STRING));
        if (phase.equals((Object)SourceGenerationPhase.completed) || phase.equals((Object)SourceGenerationPhase.error)) {
            fields.add(new Field("" + SourceGenerationRequestFields.endtime, String.valueOf(System.currentTimeMillis()), FieldType.LONG));
            fields.add(new Field("" + SourceGenerationRequestFields.currentphasepercent, "100", FieldType.DOUBLE));
        }
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void addReportId(int reportId, String id) throws Exception {
        SourceGenerationRequest req = SourceGenerationRequestsManager.getById(id);
        req.addReportId(Integer.valueOf(reportId));
        SourceGenerationRequestsManager.updateField(id, new ArrayList<Field>(Arrays.asList(req.getField(SourceGenerationRequestFields.reportid))));
    }

    public static void removeReportId(int reportId, String id) throws Exception {
        SourceGenerationRequest req = SourceGenerationRequestsManager.getById(id);
        req.removeReportId(Integer.valueOf(reportId));
        SourceGenerationRequestsManager.updateField(id, new ArrayList<Field>(Arrays.asList(req.getField(SourceGenerationRequestFields.reportid))));
    }

    public static void setPhasePercent(double percent, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("" + SourceGenerationRequestFields.currentphasepercent, String.valueOf(percent), FieldType.DOUBLE));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void addGeneratedResource(int hspecId, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList current = CSVUtils.CSVToStringList((String)SourceGenerationRequestsManager.getField(id, "" + SourceGenerationRequestFields.generatedsourcesid).getValue());
        current.add(String.valueOf(hspecId));
        fields.add(new Field("" + SourceGenerationRequestFields.generatedsourcesid, CSVUtils.listToCSV((List)current), FieldType.STRING));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void addJobIds(int jobId, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList current = CSVUtils.CSVToStringList((String)SourceGenerationRequestsManager.getField(id, "" + SourceGenerationRequestFields.jobids).getValue());
        current.add(String.valueOf(jobId));
        fields.add(new Field("" + SourceGenerationRequestFields.jobids, CSVUtils.listToCSV((List)current), FieldType.STRING));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void setToGenerateTableCount(int count, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("" + SourceGenerationRequestFields.togeneratetablescount, String.valueOf(count), FieldType.INTEGER));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void setEvaluatedComputationCount(int count, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("" + SourceGenerationRequestFields.evaluatedcomputationcount, String.valueOf(count), FieldType.INTEGER));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void setStartTime(String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("" + SourceGenerationRequestFields.starttime, String.valueOf(System.currentTimeMillis()), FieldType.LONG));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static String getJSONList(List<Field> filters, PagedRequestSettings settings) throws Exception {
        if (filters == null) {
            filters = new ArrayList<Field>();
        }
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            String string = DBUtils.toJSon(session.executeFilteredQuery(filters, requestsTable, settings.getOrderField(), settings.getOrderDirection()), settings.getOffset(), settings.getOffset() + settings.getOffset() + settings.getLimit());
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static int delete(ArrayList<Field> filter) throws Exception {
        DBSession session = null;
        if (filter == null) {
            filter = new ArrayList();
        }
        try {
            session = DBSession.getInternalDBSession();
            PreparedStatement ps = session.getPreparedStatementForDelete(filter, requestsTable);
            int n = session.fillParameters(filter, 0, ps).executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static int delete(String id) throws Exception {
        ArrayList<Field> filter = new ArrayList<Field>();
        filter.add(new Field("" + SourceGenerationRequestFields.id, id, FieldType.STRING));
        return SourceGenerationRequestsManager.delete(filter);
    }

    public static Long getCount(List<Field> filter) throws Exception {
        DBSession session = null;
        if (filter == null) {
            filter = new ArrayList<Field>();
        }
        try {
            session = DBSession.getInternalDBSession();
            Long l = session.getCount(requestsTable, filter);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static SourceGenerationRequest getById(String id) throws Exception {
        SourceGenerationRequest request = new SourceGenerationRequest();
        request.setId(id);
        ArrayList<SourceGenerationRequest> found = SourceGenerationRequestsManager.getList(new ArrayList<Field>(Arrays.asList(request.getField(SourceGenerationRequestFields.id))));
        if (found.size() > 0) {
            return found.get(0);
        }
        return null;
    }
}

