/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.BadRequestException;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis.LayerGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis.StyleGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HCAF_SFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.enabling.ParameterNotFoundException;
import org.gcube.application.aquamaps.enabling.ScopeNotFoundException;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor;
import org.gcube.application.aquamaps.enabling.model.DataSourceDescriptor;
import org.gcube.application.aquamaps.enabling.model.GeoServerDescriptor;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.bean.BoundsRest;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.engine.MakeStyle;
import org.gcube.common.gis.datamodel.enhanced.LayerInfo;
import org.gcube.common.gis.datamodel.enhanced.WMSContextInfo;
import org.gcube.common.gis.datamodel.types.LayersType;
import org.gcube.common.gis.datamodel.utils.ReadTemplate;

public class GISUtils {
    private static GCUBELog logger = new GCUBELog(GISUtils.class);
    public static char delimiter = (char)44;
    public static boolean hasHeader = false;
    private static String cSquareCodeDefinition = HCAF_SFields.csquarecode + " varchar(10)";
    private static final String crs = "GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]]";
    private static long DB_WAIT_TIME;
    private static long GEO_SERVER_WAIT_TIME;

    static {
        try {
            DB_WAIT_TIME = ServiceContext.getContext().getPropertyAsInteger("GEOSERVER_WAIT_FOR_DB_MS").intValue();
            GEO_SERVER_WAIT_TIME = ServiceContext.getContext().getPropertyAsInteger("GEOSERVER_WAIT_FOR_FT").intValue();
        }
        catch (Exception e) {
            logger.fatal((Object)"UNABLE TO LOAD GIS CONFGURATION", (Throwable)e);
        }
    }

    public static LayerInfo generateLayer(LayerGenerationRequest request) throws Exception {
        DBSession session = null;
        String layerTable = null;
        String appTableName = null;
        boolean generatedLayer = false;
        GeoCaller caller = null;
        try {
            GeoServerDescriptor geoServer = GISUtils.getGeoServer();
            DataSourceDescriptor geoNetwork = GISUtils.getGeoNetwork();
            caller = GISUtils.getCaller(geoServer, geoNetwork);
            long start = System.currentTimeMillis();
            logger.debug((Object)"Generating layer..");
            session = DBSession.getPostGisDBSession();
            session.disableAutoCommit();
            logger.debug((Object)"Importing data..");
            appTableName = GISUtils.importLayerData(request.getCsvFile(), request.getFeatureLabel(), request.getFeatureDefinition(), session);
            logger.debug((Object)("Created " + appTableName + " in " + (System.currentTimeMillis() - start)));
            layerTable = GISUtils.createLayerTable(appTableName, request.getMapName(), request.getFeatureLabel(), session);
            logger.debug((Object)("Created " + layerTable + " in " + (System.currentTimeMillis() - start)));
            session.dropTable(appTableName);
            session.commit();
            logger.debug((Object)"Committed session");
            try {
                logger.debug((Object)"Waiting for postgis-geoserver sync..");
                Thread.sleep(DB_WAIT_TIME);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (StyleGenerationRequest styleReq : request.getToGenerateStyles()) {
                if (GISUtils.generateStyle(styleReq, caller)) {
                    request.getToAssociateStyles().add(styleReq.getNameStyle());
                    continue;
                }
                logger.warn((Object)("Style " + styleReq.getNameStyle() + " was not generated!!"));
            }
            if (request.getToAssociateStyles().size() == 0) {
                throw new BadRequestException("No style to associate wtih Layer " + request.getMapName());
            }
            generatedLayer = GISUtils.createLayer(layerTable, request.getMapName(), (ArrayList)request.getToAssociateStyles(), request.getDefaultStyle(), request.getMeta(), caller, geoServer);
            if (!generatedLayer) {
                throw new Exception("Unable to generate Layer " + request.getMapName());
            }
            logger.debug((Object)("GIS GENERATOR request served in " + (System.currentTimeMillis() - start) + " layer : " + layerTable + ", geoserver was " + caller.getCurrentWmsGeoserver()));
            LayerInfo layerInfo = GISUtils.getLayer(request.getMapType(), layerTable, request.getMapName(), "NO DESCRIPTION", request.getToAssociateStyles(), request.getDefaultStyle(), geoServer, caller.getCurrentWmsGeoserver());
            return layerInfo;
        }
        catch (Exception e) {
            logger.trace((Object)"Layer generation failed, gonna clean up data.. exception was", (Throwable)e);
            if (appTableName != null) {
                try {
                    logger.debug((Object)("Found table to delete : " + appTableName));
                    session.dropTable(appTableName);
                }
                catch (Exception e1) {
                    logger.warn((Object)("Unable to drop table " + appTableName), (Throwable)e);
                }
                if (layerTable != null) {
                    logger.debug((Object)("Found layer table to delete : " + layerTable));
                    try {
                        session.dropTable(layerTable);
                    }
                    catch (Exception e1) {
                        logger.warn((Object)("Unable to drop table " + appTableName), (Throwable)e);
                    }
                    if (generatedLayer) {
                        try {
                            logger.trace((Object)("Layer deletion (" + generatedLayer + "): " + GISUtils.deleteLayer(request.getMapName(), caller)));
                        }
                        catch (Exception e1) {
                            logger.warn((Object)("Unable to delete layer " + generatedLayer), (Throwable)e);
                        }
                    }
                }
            }
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void deleteLayer(LayerInfo toDelete) throws Exception {
        logger.trace((Object)("Deleting layer " + toDelete.getName()));
        GeoServerDescriptor geoServer = GISUtils.getGeoServer();
        DataSourceDescriptor geoNetwork = GISUtils.getGeoNetwork();
        GeoCaller caller = GISUtils.getCaller(geoServer, geoNetwork);
        if (GISUtils.deleteLayer(toDelete.getName(), caller)) {
            if (!GISUtils.deleteFeatureType(geoServer.getWorkspace(), geoServer.getDatastore(), toDelete.getName(), caller)) {
                throw new Exception("Unable to delete Feature Type " + toDelete.getName());
            }
        } else {
            throw new Exception("Unable to delete layer " + toDelete.getName());
        }
        GISUtils.deleteLayerTable(toDelete.getName());
    }

    public static void deleteWMSContext(WMSContextInfo toDelete) throws Exception {
        logger.trace((Object)("DELETING wms context " + toDelete.getName()));
        GeoServerDescriptor geoServer = GISUtils.getGeoServer();
        DataSourceDescriptor geoNetwork = GISUtils.getGeoNetwork();
        GeoCaller caller = GISUtils.getCaller(geoServer, geoNetwork);
        if (!GISUtils.deleteGroup(toDelete.getName(), caller)) {
            throw new Exception("Unable to delete group " + toDelete.getName());
        }
    }

    public static GeoServerDescriptor getGeoServer() throws ParameterNotFoundException, ScopeNotFoundException {
        GCUBEScope scope = ServiceContext.getContext().getConfigurationScope();
        return (GeoServerDescriptor)ServiceContext.getContext().getConfiguration().getGeoServers(scope).get(0);
    }

    public static DataSourceDescriptor getGeoNetwork() throws ParameterNotFoundException, ScopeNotFoundException {
        GCUBEScope scope = ServiceContext.getContext().getConfigurationScope();
        return ServiceContext.getContext().getConfiguration().getGeoNetwork(scope);
    }

    private static GeoCaller getCaller(GeoServerDescriptor geoServer, DataSourceDescriptor geoNetwork) throws Exception {
        logger.debug((Object)("instatiating caller, passed arguments are GEOSERVER : " + geoServer + ", GEONETWORK : " + geoNetwork));
        return new GeoCaller(geoNetwork.getEntryPoint(), geoNetwork.getUser(), geoNetwork.getPassword(), geoServer.getEntryPoint(), geoServer.getUser(), geoServer.getPassword(), GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD);
    }

    private static String importLayerData(final String fileName, String featureLabel, String featureDefinition, DBSession session) throws Exception {
        CSVReaderProcessor processor = new CSVReaderProcessor();
        processor.setDelimiter(delimiter);
        processor.setHasHeader(hasHeader);
        logger.trace((Object)("Reading from file " + fileName));
        String tableName = ServiceUtils.generateId("app", "");
        session.createTable(tableName, new String[]{cSquareCodeDefinition, String.valueOf(featureLabel) + " " + featureDefinition});
        ArrayList<Field> toInsertFields = new ArrayList<Field>();
        toInsertFields.add(new Field("" + HCAF_SFields.csquarecode, "", FieldType.STRING));
        toInsertFields.add(new Field(featureLabel, "", FieldType.STRING));
        final PreparedStatement ps = session.getPreparedStatementForInsert(toInsertFields, tableName);
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), Charset.defaultCharset());
        final ArrayList<Integer> count = new ArrayList<Integer>();
        count.add(0);
        long start = System.currentTimeMillis();
        processor.processStream((Reader)reader, new CSVLineProcessor(){

            public boolean continueProcessing() {
                return true;
            }

            public void processDataLine(int arg0, List<String> arg1) {
                try {
                    ps.setString(1, arg1.get(0));
                    ps.setFloat(2, Float.parseFloat(arg1.get(1)));
                    count.set(0, (Integer)count.get(0) + ps.executeUpdate());
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to complete insertion from file " + fileName), (Throwable)e);
                }
            }

            public void processHeaderLine(int arg0, List<String> arg1) {
            }
        });
        logger.debug((Object)("Inserted " + count.get(0) + " in " + (System.currentTimeMillis() - start)));
        return tableName;
    }

    private static String createLayerTable(String appTableName, String layerName, String featureLabel, DBSession session) throws Exception {
        String featureTable = ServiceUtils.generateId("L" + layerName, "").replaceAll(" ", "").replaceAll("_", "").replaceAll("-", "").toLowerCase();
        String worldTable = DBSession.getPostGisCredentials().getProperty(DBDescriptor.AQUAMAPS_WORLD_TABLE);
        logger.trace((Object)("Creating table " + featureTable));
        session.executeUpdate("Create table " + featureTable + " AS (Select " + worldTable + ".*, app." + featureLabel + " FROM " + appTableName + " AS app inner join " + worldTable + " ON app." + HCAF_SFields.csquarecode + "=" + worldTable + "." + HCAF_SFields.csquarecode + ")");
        logger.trace((Object)(String.valueOf(featureTable) + " created"));
        logger.trace((Object)("going do drop appTable " + appTableName));
        session.dropTable(appTableName);
        return featureTable;
    }

    private static boolean generateStyle(StyleGenerationRequest req, GeoCaller caller) throws Exception {
        String style;
        logger.trace((Object)("Generating style " + req.getNameStyle() + " attribute :" + req.getAttributeName() + " min " + req.getMin() + " max " + req.getMax() + " N classes " + req.getNClasses()));
        if (req.getTypeValue() == Integer.class) {
            switch (req.getClusterScaleType()) {
                case logarithmic: {
                    style = MakeStyle.createStyleLog((String)req.getNameStyle(), (String)req.getAttributeName().toLowerCase(), (int)req.getNClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Integer.parseInt(req.getMax()), (Object)Integer.parseInt(req.getMin()));
                    break;
                }
                default: {
                    style = MakeStyle.createStyle((String)req.getNameStyle(), (String)req.getAttributeName().toLowerCase(), (int)req.getNClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Integer.parseInt(req.getMax()), (Object)Integer.parseInt(req.getMin()));
                    break;
                }
            }
        } else if (req.getTypeValue() == Float.class) {
            switch (req.getClusterScaleType()) {
                case logarithmic: {
                    style = MakeStyle.createStyleLog((String)req.getNameStyle(), (String)req.getAttributeName().toLowerCase(), (int)req.getNClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Float.valueOf(Float.parseFloat(req.getMax())), (Object)Float.valueOf(Float.parseFloat(req.getMin())));
                    break;
                }
                default: {
                    style = MakeStyle.createStyle((String)req.getNameStyle(), (String)req.getAttributeName().toLowerCase(), (int)req.getNClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Float.valueOf(Float.parseFloat(req.getMax())), (Object)Float.valueOf(Float.parseFloat(req.getMin())));
                    break;
                }
            }
        } else {
            throw new BadRequestException("Invalid type class : " + req.getTypeValue());
        }
        logger.trace((Object)("Submitting style " + req.getNameStyle()));
        boolean toReturn = false;
        toReturn = caller.sendStyleSDL(style);
        logger.trace((Object)("Submitting style result : " + toReturn));
        return toReturn;
    }

    private static boolean createLayer(String featureTable, String layerName, ArrayList<String> styles, int defaultStyleIndex, Map<String, String> meta, GeoCaller caller, GeoServerDescriptor geoServer) throws Exception {
        try {
            FeatureTypeRest featureTypeRest = new FeatureTypeRest();
            featureTypeRest.setDatastore(geoServer.getDatastore());
            featureTypeRest.setEnabled(true);
            featureTypeRest.setLatLonBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
            featureTypeRest.setNativeBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
            featureTypeRest.setName(featureTable);
            featureTypeRest.setNativeName(featureTable);
            featureTypeRest.setProjectionPolicy("FORCE_DECLARED");
            featureTypeRest.setSrs("EPSG:4326");
            featureTypeRest.setNativeCRS(crs);
            featureTypeRest.setTitle(layerName);
            featureTypeRest.setWorkspace(geoServer.getWorkspace());
            StringBuilder description = new StringBuilder();
            meta.put("LAYER_NAME", featureTypeRest.getName());
            if (meta != null) {
                for (Map.Entry<String, String> entry : meta.entrySet()) {
                    description.append(String.valueOf(entry.getKey()) + " : " + entry.getValue() + " | ");
                }
            }
            logger.debug((Object)"Invoking Caller for registering layer : ");
            logger.debug((Object)("featureTypeRest.getNativeName : " + featureTypeRest.getNativeName()));
            logger.debug((Object)("featureTypeRest.getTitle : " + featureTypeRest.getTitle()));
            if (caller.addFeatureType(featureTypeRest, GeonetworkCommonResourceInterface.GeonetworkCategory.DATASETS, description.toString(), "")) {
                logger.debug((Object)"Add feature type returned true .. waiting 6 secs..");
                try {
                    Thread.sleep(GEO_SERVER_WAIT_TIME);
                }
                catch (InterruptedException entry) {
                    // empty catch block
                }
                boolean setLayerValue = caller.setLayer(featureTypeRest, styles.get(defaultStyleIndex), styles);
                logger.debug((Object)("Set layer returned " + setLayerValue));
                return setLayerValue;
            }
            logger.warn((Object)"Add feature type returned false, layer has not been created.");
            return false;
        }
        catch (Exception e) {
            logger.debug((Object)"Create layer threw an exception ", (Throwable)e);
            throw e;
        }
    }

    private static LayerInfo getLayer(LayersType type, String name, String title, String abstractDescription, List<String> styles, int defaultStyleIndex, GeoServerDescriptor geoserver, String wmsUrl) throws Exception {
        LayerInfo layer = ReadTemplate.getLayerTemplate((LayersType)type);
        layer.setType(type);
        layer.setName(name);
        layer.setTitle(title);
        layer.set_abstract(abstractDescription);
        layer.setUrl(wmsUrl);
        layer.setServerProtocol("OGC:WMS");
        layer.setServerLogin(geoserver.getUser());
        layer.setServerPassword(geoserver.getPassword());
        layer.setServerType("geoserver");
        layer.setSrs("EPSG:4326");
        layer.setOpacity(1.0);
        layer.setStyles(new ArrayList());
        layer.getStyles().addAll(styles);
        layer.setDefaultStyle(styles.get(defaultStyleIndex));
        return layer;
    }

    private static boolean deleteLayer(String layerName, GeoCaller caller) throws Exception {
        return caller.deleteLayer(layerName);
    }

    private static boolean deleteFeatureType(String workspaceName, String dataStore, String featureType, GeoCaller caller) throws Exception {
        return caller.deleteFeatureTypes(workspaceName, dataStore, featureType);
    }

    private static boolean deleteLayerTable(String layerTable) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getPostGisDBSession();
            session.dropTable(layerTable);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to delete Layer table", (Throwable)e);
            return false;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static boolean deleteGroup(String groupName, GeoCaller caller) throws Exception {
        return caller.deleteLayersGroup(groupName);
    }
}

