/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.Analyzer;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalyzerFactory;
import org.gcube.common.core.utils.logging.GCUBELog;

public class AnalyzerManager {
    static GCUBELog logger = new GCUBELog(AnalyzerManager.class);
    private static GenericObjectPool analyzerPool = new GenericObjectPool((PoolableObjectFactory)new AnalyzerFactory());

    static {
        try {
            analyzerPool.setLifo(false);
            analyzerPool.setMaxActive(ServiceContext.getContext().getPropertyAsInteger("ANALYZER_BATCH_POOL_SIZE").intValue());
            analyzerPool.setWhenExhaustedAction((byte)1);
            int i = 0;
            while (i < analyzerPool.getMaxActive()) {
                analyzerPool.addObject();
                ++i;
            }
            logger.debug((Object)("Added " + analyzerPool.getMaxActive() + " objects to source generator pool"));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to init batch pool", (Throwable)e);
        }
    }

    public static Analyzer getBatch() throws Exception {
        return (Analyzer)analyzerPool.borrowObject();
    }

    public static void leaveBatch(Analyzer theBatch) throws Exception {
        analyzerPool.returnObject((Object)theBatch);
    }
}

