/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.AquaMapsObjectExecutionRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FileType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.publisher.impl.model.File;
import org.gcube.application.aquamaps.publisher.impl.model.FileSet;
import org.gcube.application.aquamaps.publisher.impl.model.Layer;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;

public class AquaMapsManager
extends SubmittedManager {
    public static String maxSpeciesCountInACell = "maxspeciescountinacell";

    public static int insertRequests(List<AquaMapsObjectExecutionRequest> requests) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            session.disableAutoCommit();
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            for (AquaMapsObjectExecutionRequest request : requests) {
                ArrayList<Field> fields = new ArrayList<Field>();
                fields.add(request.getObject().getField(SubmittedFields.serializedrequest));
                fields.add(request.getObject().getField(SubmittedFields.status));
                rows.add(fields);
                ArrayList<Field> key = new ArrayList<Field>();
                key.add(request.getObject().getField(SubmittedFields.searchid));
                keys.add(key);
            }
            int toReturn = session.updateOperation("submitted", keys, rows);
            session.commit();
            int n = toReturn;
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<Submitted> getObjectsByCoverage(Integer hspecId, String md5SpeciesCoverage, Boolean isGIS, boolean includeCustomized) throws Exception {
        DBSession session = null;
        try {
            logger.debug((Object)("looking for objects by coverage HSPEC ID=" + hspecId + ", md5=" + md5SpeciesCoverage + ", GIS=" + isGIS + ", custom=" + includeCustomized));
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            if (hspecId != null) {
                filter.add(new Field(SubmittedFields.sourcehspec + "", hspecId + "", FieldType.INTEGER));
            }
            if (md5SpeciesCoverage != null) {
                filter.add(new Field(SubmittedFields.speciescoverage + "", md5SpeciesCoverage, FieldType.STRING));
            }
            if (!includeCustomized) {
                filter.add(new Field(SubmittedFields.iscustomized + "", "false", FieldType.BOOLEAN));
            }
            filter.add(new Field(SubmittedFields.status + "", SubmittedStatus.Completed + "", FieldType.STRING));
            filter.add(new Field(SubmittedFields.isaquamap + "", "true", FieldType.BOOLEAN));
            if (isGIS != null) {
                filter.add(new Field(SubmittedFields.gisenabled + "", isGIS + "", FieldType.BOOLEAN));
            }
            ArrayList arrayList = Submitted.loadResultSet((ResultSet)session.executeFilteredQuery(filter, "submitted", SubmittedFields.searchid + "", OrderDirection.ASC));
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static AquaMapsObject loadObject(int objId, boolean loadFileSet, boolean loadLayers) throws Exception {
        if (!AquaMapsManager.isAquaMap(objId).booleanValue()) {
            throw new Exception("Selected ID " + objId + " doesn't refere to an AquaMapsObject");
        }
        Submitted submittedObj = AquaMapsManager.getSubmittedById(objId);
        logger.info((Object)("Loading object " + submittedObj));
        AquaMapsObject toReturn = (AquaMapsObject)AquaMapsXStream.deSerialize((String)submittedObj.getSerializedObject());
        toReturn.setId(objId);
        toReturn.setAlgorithmType(SourceManager.getById(submittedObj.getSourceHSPEC()).getAlgorithm());
        toReturn.setStatus(submittedObj.getStatus());
        if (loadFileSet) {
            try {
                String publisherHost = ServiceContext.getContext().getPublisher().getWebServerUrl();
                FileSet fileSet = (FileSet)ServiceContext.getContext().getPublisher().getById(FileSet.class, submittedObj.getFileSetId());
                for (File f : fileSet.getFiles()) {
                    toReturn.getImages().add(new org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File(FileType.valueOf((String)(f.getType() + "")), publisherHost + f.getStoredUri(), f.getName()));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unablet o load fileset for obj " + objId));
            }
        }
        if (loadLayers && submittedObj.getGisEnabled().booleanValue()) {
            try {
                Layer layer = (Layer)ServiceContext.getContext().getPublisher().getById(Layer.class, submittedObj.getGisPublishedId());
                toReturn.getLayers().add(layer.getLayerInfo());
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to load Layer " + submittedObj.getGisPublishedId()));
            }
        }
        return toReturn;
    }

    public static Map<String, String> getMetaForGIS(Submitted obj) throws Exception {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        Resource hspec = SourceManager.getById(obj.getSourceHSPEC());
        Resource hspen = SourceManager.getById(obj.getSourceHSPEN());
        Resource hcaf = SourceManager.getById(obj.getSourceHCAF());
        toReturn.put("ALGORITHM", hspec.getAlgorithm() + "");
        toReturn.put("ALGORITHM CITATION", "Kaschner, K., J. S. Ready, E. Agbayani, J. Rius, K. Kesner-Reyes, P. D. Eastwood, A. B. South, S. O. Kullander, T. Rees, C. H. Close, R. Watson, D. Pauly, and R. Froese. 2008 AquaMaps: Predicted range maps for aquatic species. World wide web electronic publication, www.aquamaps.org, Version 10/2008.");
        toReturn.put("HSPEC TITLE", hspec.getTitle());
        toReturn.put("HSPEC GENERATION TIME", ServiceUtils.formatTimeStamp(hspec.getGenerationTime()));
        toReturn.put("HSPEN TITLE", hspen.getTitle());
        toReturn.put("HSPEN GENERATION TIME", ServiceUtils.formatTimeStamp(hspen.getGenerationTime()));
        toReturn.put("HCAF TITLE", hcaf.getTitle());
        toReturn.put("HCAF GENERATION TIME", ServiceUtils.formatTimeStamp(hcaf.getGenerationTime()));
        return toReturn;
    }
}

