/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ExtendedExecutor;
import org.gcube.common.core.utils.logging.GCUBELog;

public class MyPooledExecutor
extends ThreadPoolExecutor
implements ExtendedExecutor {
    private static final GCUBELog logger = new GCUBELog(MyPooledExecutor.class);

    private MyPooledExecutor(String threadLabel, int maxThread) {
        super(maxThread, maxThread, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxThread * 2), new MyThreadFactory(threadLabel), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public String getDetails() {
        StringBuilder statusBuilder = new StringBuilder();
        statusBuilder.append("Active Count : " + this.getActiveCount() + ";");
        statusBuilder.append("Core Size : " + this.getCorePoolSize() + ";");
        statusBuilder.append("Maximum pool size: " + this.getMaximumPoolSize() + ";");
        statusBuilder.append("Current Queue size: " + this.getQueue().size() + ";");
        statusBuilder.append("Largest pool size : " + this.getLargestPoolSize() + ";");
        statusBuilder.append("Executed Count : " + this.getCompletedTaskCount() + ";");
        return statusBuilder.toString();
    }

    public static ExtendedExecutor getExecutor(String threadLabel, int maxThread) {
        return new MyPooledExecutor(threadLabel, maxThread);
    }

    protected static class MyThreadFactory
    implements ThreadFactory {
        private String label;
        private int priority;
        private boolean setPriority;
        private int index = 0;

        public MyThreadFactory(String threadLabel, int priority) {
            this.label = threadLabel;
            this.priority = priority;
            this.setPriority = true;
        }

        public MyThreadFactory(String threadLabel) {
            this.label = threadLabel;
            this.setPriority = false;
        }

        @Override
        public Thread newThread(Runnable arg0) {
            Thread toReturn = Executors.defaultThreadFactory().newThread(arg0);
            toReturn.setName(this.label + this.index);
            ++this.index;
            if (this.setPriority) {
                toReturn.setPriority(this.priority);
            }
            return toReturn;
        }
    }
}

