/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables;

import java.util.Arrays;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.LogicType;

class Execution {
    private AlgorithmType algorithm;
    private int[] sources;
    private LogicType logic;
    private String parameters;

    public LogicType getLogic() {
        return this.logic;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public int[] getSources() {
        return this.sources;
    }

    public String getParameters() {
        return this.parameters;
    }

    public Execution(AlgorithmType algorithm, LogicType logic, int[] sources, String parameters) throws Exception {
        this.algorithm = algorithm;
        this.sources = sources;
        if (sources == null || sources.length == 0) {
            throw new Exception("Sources cannot be empty");
        }
        Arrays.sort(this.sources);
        this.logic = logic;
        this.parameters = parameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + (this.logic == null ? 0 : this.logic.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + Arrays.hashCode(this.sources);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Execution other = (Execution)obj;
        if (this.algorithm != other.algorithm) {
            return false;
        }
        if (this.logic != other.logic) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return Arrays.equals(this.sources, other.sources);
    }

    public String toString() {
        return "Execution [algorithm=" + this.algorithm + ", sources=" + Arrays.toString(this.sources) + ", logic=" + this.logic + ", parameters=" + this.parameters + "]";
    }
}

