/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HSPECFields;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;

public class PostGresSQLDBSession
extends DBSession {
    public PostGresSQLDBSession(Connection conn) {
        super(conn);
    }

    @Override
    public ResultSet executeFilteredQuery(List<Field> filters, String table, String orderColumn, OrderDirection orderMode) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForQuery(filters, table, orderColumn, orderMode);
        return this.fillParameters(filters, 0, ps).executeQuery();
    }

    @Override
    public PreparedStatement fillParameters(List<Field> fields, int parameterOffset, PreparedStatement ps) throws SQLException {
        block12: for (int i = 0; i < fields.size(); ++i) {
            int psIndex = i + 1 + parameterOffset;
            Field f = fields.get(i);
            if (f.isNull()) {
                ps.setNull(psIndex, ps.getParameterMetaData().getParameterType(psIndex));
                continue;
            }
            switch (f.getType()) {
                case BOOLEAN: {
                    Integer value = f.getValueAsBoolean() != false ? 1 : 0;
                    ps.setInt(psIndex, value);
                    continue block12;
                }
                case DOUBLE: {
                    ps.setDouble(psIndex, f.getValueAsDouble());
                    continue block12;
                }
                case INTEGER: {
                    try {
                        ps.setInt(psIndex, f.getValueAsInteger());
                    }
                    catch (NumberFormatException e) {
                        ps.setLong(psIndex, Long.parseLong(f.getValue()));
                    }
                    continue block12;
                }
                case TIMESTAMP: {
                    try {
                        ps.setTimestamp(psIndex, Timestamp.valueOf(f.getValue()));
                    }
                    catch (IllegalArgumentException e) {
                        ps.setNull(psIndex, 93);
                    }
                    continue block12;
                }
                case STRING: {
                    ps.setString(psIndex, f.getValue());
                    continue block12;
                }
                case LONG: {
                    ps.setLong(psIndex, f.getValueAsLong());
                }
            }
        }
        return ps;
    }

    @Override
    public boolean checkExist(String tableName, List<Field> keys) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForQuery(keys, tableName, null, null);
        ResultSet rs = this.fillParameters(keys, 0, ps).executeQuery();
        return rs.first();
    }

    @Override
    public int deleteOperation(String tableName, List<Field> filters) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForDelete(filters, tableName);
        return this.fillParameters(filters, 0, ps).executeUpdate();
    }

    @Override
    public Long getCount(String tableName, List<Field> filters) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForCount(filters, tableName);
        ResultSet rs = this.fillParameters(filters, 0, ps).executeQuery();
        if (rs.next()) {
            return rs.getLong(1);
        }
        return 0L;
    }

    @Override
    public PreparedStatement getFilterCellByAreaQuery(HSPECFields filterByCodeType, String sourceTableName, String destinationTableName) throws Exception {
        String conditionString = null;
        switch (filterByCodeType) {
            case eezall: {
                conditionString = " ? NOT IN s." + filterByCodeType;
                break;
            }
            default: {
                conditionString = " s." + filterByCodeType + "= ? ";
            }
        }
        String query = "INSERT INTO " + destinationTableName + " (SELECT * FROM " + sourceTableName + " s WHERE " + conditionString + " EXCEPT " + "( SELECT * FROM " + destinationTableName + " ) )";
        logger.trace((Object)("FILTER STRING : " + query));
        return this.preparedStatement(query);
    }

    @Override
    public List<List<Field>> insertOperation(String tableName, List<List<Field>> rows) throws Exception {
        ArrayList<List<Field>> toReturn = new ArrayList<List<Field>>();
        if (rows.size() == 0) {
            throw new Exception("Empty rows to insert");
        }
        PreparedStatement ps = this.getPreparedStatementForInsert(rows.get(0), tableName);
        for (List<Field> row : rows) {
            ps = this.fillParameters(row, 0, ps);
            if (ps.executeUpdate() <= 0) continue;
            toReturn.addAll(this.getGeneratedKeys(ps));
        }
        return toReturn;
    }

    @Override
    public int updateOperation(String tableName, List<List<Field>> keys, List<List<Field>> rows) throws Exception {
        int count = 0;
        if (rows.size() == 0) {
            throw new Exception("Empty rows to insert");
        }
        if (keys.size() == 0) {
            throw new Exception("Empty keys");
        }
        if (rows.size() != keys.size()) {
            throw new Exception("Un matching rows/keys sizes " + rows.size() + "/" + keys.size());
        }
        PreparedStatement ps = this.getPreparedStatementForUpdate(rows.get(0), keys.get(0), tableName);
        for (int i = 0; i < rows.size(); ++i) {
            ps = this.fillParameters(rows.get(i), 0, ps);
            ps = this.fillParameters(keys.get(i), rows.get(i).size(), ps);
            count += ps.executeUpdate();
        }
        return count;
    }

    @Override
    public void createLikeTable(String newTableName, String oldTable) throws Exception {
        this.dropTable(newTableName);
        Statement statement = this.connection.createStatement();
        statement.executeUpdate("CREATE TABLE  " + newTableName + " ( LIKE " + oldTable + " )");
        statement.close();
    }

    @Override
    public void createTable(String tableName, String[] columnsAndConstraintDefinition) throws Exception {
        this.dropTable(tableName);
        Statement statement = this.connection.createStatement();
        StringBuilder createQuery = new StringBuilder("CREATE TABLE " + tableName + " (");
        for (String singleColumnDef : columnsAndConstraintDefinition) {
            createQuery.append(singleColumnDef + ",");
        }
        createQuery.deleteCharAt(createQuery.length() - 1);
        createQuery.append(") ");
        logger.debug((Object)("the query is: " + createQuery.toString()));
        statement.executeUpdate(createQuery.toString());
        statement.close();
    }

    @Override
    public PreparedStatement getPreparedStatementForInsertOnDuplicate(List<Field> fields, String table, Integer[] keyIndexes) throws Exception {
        throw new Exception("YET TO IMPLEMENT");
    }

    @Override
    public ResultSet getDistinct(Field toSelect, List<Field> filters, String table, String orderColumn, OrderDirection orderMode) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForDISTINCT(filters, toSelect, table, orderColumn, orderMode);
        return this.fillParameters(filters, 0, ps).executeQuery();
    }

    @Override
    public String exportTableToCSV(String tableName, boolean hasHeaders, char delimiter) throws Exception {
        Statement stmt = null;
        try {
            File out = new File(ServiceContext.getContext().getFolderPath(ServiceContext.FOLDERS.IMPORTS), ServiceUtils.generateId(tableName, ".csv"));
            stmt = this.connection.createStatement();
            String copyString = "COPY " + tableName + " TO '" + out.getAbsolutePath() + "' WITH DELIMITER '" + delimiter + "'" + (hasHeaders ? " CSV HEADER" : "");
            logger.debug((Object)("Gonna execute copy  : " + copyString));
            stmt.execute(copyString);
            String string = out.getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }
}

