/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetJSONSubmittedByFiltersRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.PublisherServicePortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.RetrieveMapsByCoverageRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMap;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FileType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ObjectType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.application.aquamaps.publisher.Publisher;
import org.gcube.application.aquamaps.publisher.impl.model.CoverageDescriptor;
import org.gcube.application.aquamaps.publisher.impl.model.File;
import org.gcube.application.aquamaps.publisher.impl.model.FileSet;
import org.gcube.application.aquamaps.publisher.impl.model.Layer;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube_system.namespaces.application.aquamaps.gistypes.LayerInfoType;
import org.gcube_system.namespaces.application.aquamaps.types.FieldArray;
import org.gcube_system.namespaces.application.aquamaps.types.FileArray;
import org.gcube_system.namespaces.application.aquamaps.types.MapArray;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;

public class PublisherService
extends GCUBEPortType
implements PublisherServicePortType {
    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public MapArray retrieveMapsByCoverage(RetrieveMapsByCoverageRequestType arg0) throws RemoteException, GCUBEFault {
        try {
            Submitted found;
            CoverageDescriptor descr;
            long starttime = System.currentTimeMillis();
            if (arg0.getSpeciesList() == null || arg0.getSpeciesList().getItems() == null || arg0.getSpeciesList().getItems().length == 0) {
                throw new Exception("No species specified");
            }
            String[] speciesArray = arg0.getSpeciesList().getItems();
            Publisher publisher = ServiceContext.getContext().getPublisher();
            ArrayList foundFileSet = new ArrayList();
            ArrayList foundLayers = new ArrayList();
            foundLayers.addAll(publisher.getLayersBySpeciesIds(speciesArray[0]));
            foundFileSet.addAll(publisher.getFileSetsBySpeciesIds(speciesArray[0]));
            HashMap<CoverageDescriptor, AquaMap> formedMaps = new HashMap<CoverageDescriptor, AquaMap>();
            HashMap<Integer, AquaMap> formedCustomMaps = new HashMap<Integer, AquaMap>();
            Submitted s = new Submitted(Integer.valueOf(0));
            ArrayList<Field> fileSetFilter = new ArrayList<Field>();
            fileSetFilter.add(s.getField(SubmittedFields.filesetid));
            ArrayList<Field> layerFilter = new ArrayList<Field>();
            layerFilter.add(s.getField(SubmittedFields.gispublishedid));
            PagedRequestSettings pagedSettings = new PagedRequestSettings(1, 0, OrderDirection.ASC, SubmittedFields.searchid + "");
            for (FileSet fSet : foundFileSet) {
                descr = new CoverageDescriptor(fSet.getTableId(), fSet.getParameters());
                if (fSet.isCustomized()) {
                    try {
                        ((Field)fileSetFilter.get(0)).setValue(fSet.getId());
                        found = SubmittedManager.getList(fileSetFilter, pagedSettings).get(0);
                        formedCustomMaps.put(found.getSearchId(), this.formMap((CoverageDescriptor)fSet));
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)("Unable to find an object for FS ID " + fSet.getId()));
                        this.logger.debug((Object)"Exception was ", (Throwable)e);
                    }
                    continue;
                }
                if (formedMaps.containsKey(descr)) {
                    this.logger.warn((Object)("Multiple FileSet found for Coverage, current FS ID :  " + fSet.getId() + ", previous : " + ((AquaMap)formedMaps.get(descr)).getFileSetId()));
                    continue;
                }
                formedMaps.put(descr, this.formMap((CoverageDescriptor)fSet));
            }
            for (Layer l : foundLayers) {
                descr = new CoverageDescriptor(l.getTableId(), l.getParameters());
                if (l.isCustomized()) {
                    try {
                        ((Field)layerFilter.get(0)).setValue(l.getId());
                        found = SubmittedManager.getList(layerFilter, pagedSettings).get(0);
                        if (formedCustomMaps.containsKey(found.getSearchId())) {
                            AquaMap toUpdate = (AquaMap)formedCustomMaps.get(found.getSearchId());
                            toUpdate.setLayer(l.getLayerInfo());
                            toUpdate.setGis(true);
                            toUpdate.setLayerId(l.getId());
                            continue;
                        }
                        formedCustomMaps.put(found.getSearchId(), this.formMap((CoverageDescriptor)l));
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)("Unable to find an object for layer ID " + l.getId()));
                        this.logger.debug((Object)"Exception was ", (Throwable)e);
                    }
                    continue;
                }
                if (formedMaps.containsKey(descr)) {
                    if (((AquaMap)formedMaps.get(descr)).isGis()) {
                        this.logger.warn((Object)("Multiple Layer found for Coverage, current layer ID :  " + l.getId() + ", previous : " + ((AquaMap)formedMaps.get(descr)).getLayerId()));
                        continue;
                    }
                    AquaMap toUpdate = (AquaMap)formedMaps.get(descr);
                    toUpdate.setLayer(l.getLayerInfo());
                    toUpdate.setGis(true);
                    toUpdate.setLayerId(l.getId());
                    continue;
                }
                formedMaps.put(descr, this.formMap((CoverageDescriptor)l));
            }
            ArrayList toReturn = new ArrayList(formedMaps.values());
            toReturn.addAll(formedCustomMaps.values());
            return AquaMap.toStubsVersion(toReturn);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to get Maps ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public FileArray getFileSetById(String arg0) throws RemoteException, GCUBEFault {
        try {
            Publisher publisher = ServiceContext.getContext().getPublisher();
            String publisherHost = ServiceContext.getContext().getPublisher().getWebServerUrl();
            FileSet fSet = (FileSet)publisher.getById(FileSet.class, arg0);
            if (fSet != null) {
                ArrayList<org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File> list = new ArrayList<org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File>();
                for (File f : fSet.getFiles()) {
                    list.add(new org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File(FileType.valueOf((String)(f.getType() + "")), publisherHost + f.getStoredUri(), f.getName()));
                }
                return org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File.toStubsVersion(list);
            }
            throw new Exception("FileSet with Id " + arg0 + " not found");
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to get FileSet ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String getJSONSubmittedByFilters(GetJSONSubmittedByFiltersRequestType arg0) throws RemoteException, GCUBEFault {
        try {
            return SubmittedManager.getJsonList(Field.load((FieldArray)arg0.getFilters()), arg0.getSettings());
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to get Submitted ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public LayerInfoType getLayerById(String arg0) throws RemoteException, GCUBEFault {
        try {
            Publisher publisher = ServiceContext.getContext().getPublisher();
            Layer layer = (Layer)publisher.getById(Layer.class, arg0);
            if (layer != null) {
                return layer.getLayerInfo().toStubsVersion();
            }
            throw new Exception("Layer with Id " + arg0 + " not found");
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to get Layer ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    protected AquaMap formMap(CoverageDescriptor desc) throws Exception {
        AquaMap toAdd = new AquaMap();
        toAdd.setCoverage(desc.getParameters());
        Resource source = SourceManager.getById(SourceManager.getDefaultId(ResourceType.HSPEC));
        try {
            source = SourceManager.getById(Integer.parseInt(desc.getTableId()));
        }
        catch (Exception e) {
            this.logger.warn((Object)("Unable to load resource from coverage , " + desc.getTableId()), (Throwable)e);
        }
        toAdd.setResource(source);
        if (desc instanceof FileSet) {
            String publisherHost = ServiceContext.getContext().getPublisher().getWebServerUrl();
            FileSet fSet = (FileSet)desc;
            toAdd.setAuthor(fSet.getMetaInfo().getAuthor());
            toAdd.setFileSetId(fSet.getId());
            ArrayList<org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File> files = new ArrayList<org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File>();
            for (File f : fSet.getFiles()) {
                files.add(new org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File(FileType.valueOf((String)(f.getType() + "")), publisherHost + f.getStoredUri(), f.getName()));
            }
            toAdd.setFiles(files);
            toAdd.setTitle(fSet.getMetaInfo().getTitle());
            toAdd.setSpeciesCsvList(CSVUtils.listToCSV(Arrays.asList(fSet.getSpeciesIds())));
            toAdd.setCreationDate(fSet.getMetaInfo().getDate());
            toAdd.setMapType(fSet.getSpeciesIds().length > 1 ? ObjectType.Biodiversity : ObjectType.SpeciesDistribution);
            toAdd.setCustom(Boolean.valueOf(fSet.isCustomized()));
        } else if (desc instanceof Layer) {
            Layer l = (Layer)desc;
            toAdd.setAuthor(l.getMetaInfo().getAuthor());
            toAdd.setGis(true);
            toAdd.setLayer(l.getLayerInfo());
            toAdd.setSpeciesCsvList(CSVUtils.listToCSV(Arrays.asList(l.getSpeciesIds())));
            toAdd.setLayerId(l.getId());
            toAdd.setTitle(l.getMetaInfo().getTitle());
            toAdd.setSpeciesCsvList(CSVUtils.listToCSV(Arrays.asList(l.getSpeciesIds())));
            toAdd.setCreationDate(l.getMetaInfo().getDate());
            toAdd.setMapType(l.getSpeciesIds().length > 1 ? ObjectType.Biodiversity : ObjectType.SpeciesDistribution);
            toAdd.setCustom(Boolean.valueOf(l.isCustomized()));
        }
        return toAdd;
    }
}

