/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps;

import java.io.File;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.JobManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SpeciesManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.BiodiversityObjectExecutionRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.DistributionObjectExecutionRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.JobExecutionManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorI;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.EnvironmentalLogicManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.AquaMapsObjectExecutionRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ConfigurationManager;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Area;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Job;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Perturbation;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.EnvelopeFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HSPECFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ObjectType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.common.core.utils.logging.GCUBELog;

public class JobWorker
extends Thread {
    private static final GCUBELog logger = new GCUBELog(JobWorker.class);
    private Job current;
    private Submitted tableReference;

    public JobWorker(Job toExecute, Submitted submittedReference) {
        this.current = toExecute;
        this.tableReference = submittedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.trace((Object)("Starting execution for job : " + this.tableReference.getSearchId()));
        try {
            SubmittedManager.setStartTime(this.tableReference.getSearchId());
            this.current.setId(this.tableReference.getSearchId().intValue());
            this.current = JobManager.insertNewJob(this.current);
            if (this.current.getStatus().equals((Object)SubmittedStatus.Completed)) {
                logger.debug((Object)("No need to generate for job " + this.tableReference.getSearchId() + ", publisher returned Complete."));
            } else {
                JobWorker.generateHSPEC(this.current);
                logger.debug((Object)"Generating requests for related objects..");
                ArrayList<AquaMapsObjectExecutionRequest> toSubmitRequests = new ArrayList<AquaMapsObjectExecutionRequest>();
                for (AquaMapsObject object : this.current.getAquaMapsObjectList()) {
                    if (object.getStatus().equals((Object)SubmittedStatus.Completed)) continue;
                    if (object.getType().equals((Object)ObjectType.Biodiversity)) {
                        HashMap<String, Map<String, Perturbation>> envelopeCustomization = new HashMap<String, Map<String, Perturbation>>();
                        for (String id : this.current.getEnvelopeCustomization().keySet()) {
                            Species spec = new Species(id);
                            if (!object.getSelectedSpecies().contains(spec)) continue;
                            envelopeCustomization.put(id, (Map<String, Perturbation>)this.current.getEnvelopeCustomization().get(id));
                        }
                        HashMap<String, Map<EnvelopeFields, Field>> envelopeWeights = new HashMap<String, Map<EnvelopeFields, Field>>();
                        for (String id : this.current.getEnvelopeWeights().keySet()) {
                            Species spec = new Species(id);
                            if (!object.getSelectedSpecies().contains(spec)) continue;
                            envelopeWeights.put(id, (Map<EnvelopeFields, Field>)this.current.getEnvelopeWeights().get(id));
                        }
                        toSubmitRequests.add(new BiodiversityObjectExecutionRequest(SubmittedManager.getSubmittedById(object.getId()), this.current.getSelectedAreas(), object.getBoundingBox(), object.getThreshold(), object.getSelectedSpecies(), envelopeCustomization, envelopeWeights));
                        continue;
                    }
                    Species selected = (Species)object.getSelectedSpecies().iterator().next();
                    HashMap<String, Perturbation> envelopeCustomization = this.current.getEnvelopeCustomization().containsKey(selected.getId()) ? (Map)this.current.getEnvelopeCustomization().get(selected.getId()) : new HashMap<String, Perturbation>();
                    HashMap<EnvelopeFields, Field> envelopeWeights = this.current.getEnvelopeWeights().containsKey(selected.getId()) ? (Map)this.current.getEnvelopeWeights().get(selected.getId()) : new HashMap<EnvelopeFields, Field>();
                    toSubmitRequests.add(new DistributionObjectExecutionRequest(SubmittedManager.getSubmittedById(object.getId()), this.current.getSelectedAreas(), object.getBoundingBox(), object.getSelectedSpecies(), envelopeCustomization, envelopeWeights, object.getAlgorithmType()));
                }
                SubmittedManager.updateStatus(this.tableReference.getSearchId(), SubmittedStatus.Generating);
                logger.debug((Object)("Job " + this.tableReference.getSearchId() + " must wait for " + toSubmitRequests.size() + " object to complete.."));
                if (toSubmitRequests.size() > 0) {
                    JobExecutionManager.insertAquaMapsObjectExecutionRequest(toSubmitRequests);
                }
                SubmittedManager.updateStatus(this.tableReference.getSearchId(), SubmittedStatus.Completed);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed Job execution " + this.tableReference.getSearchId()), (Throwable)e);
            try {
                SubmittedManager.updateStatus(this.tableReference.getSearchId(), SubmittedStatus.Error);
            }
            catch (Exception e1) {
                logger.error((Object)"Unexpected Error ", (Throwable)e1);
            }
        }
        finally {
            JobExecutionManager.cleanReferences(this.tableReference);
        }
    }

    private static void generateHSPEC(Job toExecute) throws Exception {
        boolean filteredArea;
        Map weights = toExecute.getEnvelopeWeights();
        Map envelopePert = toExecute.getEnvelopeCustomization();
        int jobId = toExecute.getId();
        Set area = toExecute.getSelectedAreas();
        boolean needToGenerate = weights.size() > 0 || envelopePert.size() > 0;
        boolean bl = filteredArea = area.size() > 0;
        if (filteredArea && needToGenerate) {
            logger.debug((Object)(" jobId " + jobId + " : Filter By Area and Re-generate"));
            String filteredHcaf = JobWorker.filterByArea(jobId, (Set<Area>)area, ResourceType.HCAF, JobManager.getHCAFTableId(jobId));
            JobManager.setWorkingHCAF(jobId, filteredHcaf);
            String generatedHSPEC = JobWorker.generateHSPEC(jobId, toExecute.getSelectedSpecies(), toExecute.getSourceHSPEN().getTableName(), toExecute.getSourceHSPEC().getAlgorithm(), weights);
            String toUseHSPEC = JobWorker.filterByArea(jobId, (Set<Area>)area, ResourceType.HSPEC, generatedHSPEC);
            JobManager.setWorkingHSPEC(jobId, toUseHSPEC);
            JobManager.addToDropTableList(jobId, generatedHSPEC);
            JobManager.addToDropTableList(jobId, toUseHSPEC);
        } else if (filteredArea) {
            logger.debug((Object)(" jobId " + jobId + " : Filter By Area"));
            String table = JobWorker.filterByArea(jobId, (Set<Area>)area, ResourceType.HSPEC, SubmittedManager.getHSPECTableId(jobId));
            JobManager.setWorkingHSPEC(jobId, table);
            JobManager.addToDropTableList(jobId, table);
        } else if (needToGenerate) {
            logger.debug((Object)(" jobId " + jobId + " : Re-generate"));
            String generatedHSPEC = JobWorker.generateHSPEC(jobId, toExecute.getSelectedSpecies(), toExecute.getSourceHSPEN().getTableName(), toExecute.getSourceHSPEC().getAlgorithm(), weights);
            JobManager.setWorkingHSPEC(jobId, generatedHSPEC);
            JobManager.addToDropTableList(jobId, generatedHSPEC);
        } else {
            logger.debug((Object)(" jobId " + jobId + " no needs"));
            JobManager.setWorkingHSPEC(jobId, SourceManager.getSourceName(JobManager.getHSPECTableId(jobId)));
        }
    }

    private static String filterByArea(int jobId, Set<Area> areaSelection, ResourceType tableType, int sourceId) throws Exception {
        return JobWorker.filterByArea(jobId, areaSelection, tableType, SourceManager.getSourceName(sourceId));
    }

    @Deprecated
    private static String filterByArea(int jobId, Set<Area> areaSelection, ResourceType tableType, String sourceTable) throws Exception {
        logger.trace((Object)(" filtering on area selection for jobId:" + jobId));
        DBSession conn = null;
        try {
            conn = DBSession.getInternalDBSession();
            String filteredTable = ServiceUtils.generateId(tableType.toString().toLowerCase(), "");
            String sourceTableName = sourceTable;
            conn.createLikeTable(filteredTable, sourceTableName);
            JobManager.addToDropTableList(jobId, filteredTable);
            PreparedStatement psFAO = conn.getFilterCellByAreaQuery(HSPECFields.faoaream, sourceTableName, filteredTable);
            PreparedStatement psLME = conn.getFilterCellByAreaQuery(HSPECFields.lme, sourceTableName, filteredTable);
            PreparedStatement psEEZ = conn.getFilterCellByAreaQuery(HSPECFields.eezall, sourceTableName, filteredTable);
            block10: for (Area area : areaSelection) {
                switch (area.getType()) {
                    case LME: {
                        psLME.setInt(1, Integer.parseInt(area.getCode()));
                        psLME.executeUpdate();
                        continue block10;
                    }
                    case FAO: {
                        psFAO.setInt(1, Integer.parseInt(area.getCode()));
                        psFAO.executeUpdate();
                        continue block10;
                    }
                    case EEZ: {
                        psEEZ.setInt(1, Integer.parseInt(area.getCode()));
                        psEEZ.executeUpdate();
                        continue block10;
                    }
                }
                logger.warn((Object)(" Invalid area type , skipped selection : code = " + area.getCode() + "; type = " + area.getType() + "; name = " + area.getName()));
            }
            String string = filteredTable;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (conn != null && !conn.getConnection().isClosed()) {
                conn.close();
            }
        }
    }

    private static String generateHSPEC(int jobId, Set<Species> selection, String sourceHspen, AlgorithmType algorithm, Map<String, Map<EnvelopeFields, Field>> weights) throws Exception {
        String string;
        block5: {
            String filteredHSPEN = SpeciesManager.getFilteredHSPEN(JobManager.getWorkingHSPEN(jobId), selection);
            JobManager.setWorkingHSPEN(jobId, filteredHSPEN);
            JobManager.addToDropTableList(jobId, filteredHSPEN);
            BatchGeneratorI generator = null;
            try {
                logger.trace((Object)"Requesting batch generator for custom HSPEC");
                generator = EnvironmentalLogicManager.getBatch(ServiceContext.getContext().getName());
                generator.setConfiguration(ServiceContext.getContext().getEcoligicalConfigDir() + File.separator, ConfigurationManager.getVODescriptor().getInternalDB());
                string = generator.generateHSPECTable(JobManager.getWorkingHCAF(jobId), JobManager.getWorkingHSPEN(jobId), "maxminlat_" + sourceHspen, algorithm, false, "");
                if (generator == null) break block5;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        EnvironmentalLogicManager.leaveBatch(generator);
                    }
                    throw throwable;
                }
            }
            EnvironmentalLogicManager.leaveBatch(generator);
        }
        return string;
    }
}

