/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl;

import java.io.File;
import java.io.IOException;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads.DeletionMonitor;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalysisManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.JobExecutionManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables.TableGenerationExecutionManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.monitor.StatusMonitorThread;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.FileSetUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.PropertiesReader;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ConfigurationManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DBDescriptor;
import org.gcube.application.aquamaps.publisher.Publisher;
import org.gcube.application.aquamaps.publisher.PublisherConfiguration;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;

public class ServiceContext
extends GCUBEServiceContext {
    private static ServiceContext cache = new ServiceContext();
    private Publisher publisher;
    private String configurationScope;

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    protected String getJNDIName() {
        return "gcube/application/aquamaps/aquamapsservice";
    }

    protected void onReady() throws Exception {
        super.onReady();
    }

    public void onInitialisation() throws Exception {
        Thread t;
        this.logger.trace((Object)"Initializing AquaMaps Service Context...");
        super.onInitialisation();
        try {
            GCUBEScope infrastructureScope = GHNContext.getContext().getStartScopes()[0].getInfrastructure();
            this.configurationScope = ConfigurationManager.init(infrastructureScope);
            this.logger.trace((Object)("Configuration Scope will be " + this.configurationScope));
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to init configuration", (Throwable)e);
            throw e;
        }
        try {
            DBDescriptor publisherDB = ConfigurationManager.getVODescriptor().getPublisherDB();
            this.logger.debug((Object)("Publisher Database is " + publisherDB));
            this.publisher = Publisher.getPublisher();
            PublisherConfiguration config = new PublisherConfiguration(publisherDB.getEntryPoint(), publisherDB.getUser(), publisherDB.getPassword(), this.getPersistenceRoot(), (String)this.getProperty("httpServerBasePath", new boolean[]{true}), Integer.parseInt((String)this.getProperty("httpServerPort", new boolean[]{true})));
            this.publisher.initialize(config);
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to initiate Publisher library ", (Throwable)e);
            throw e;
        }
        try {
            ServiceUtils.deleteFile(FileSetUtils.getTempMapsFolder());
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to clean temp maps folder", (Throwable)e);
            throw e;
        }
        try {
            t = new StatusMonitorThread(this.getPropertyAsInteger("MONITOR_INTERVAL").intValue(), this.getPropertyAsInteger("MONITOR_FREESPACE_THRESHOLD").intValue());
            this.logger.debug((Object)("Staring monitor thread: interval = " + this.getPropertyAsInteger("MONITOR_INTERVAL") + "; freespaceThreshold=" + this.getPropertyAsInteger("MONITOR_FREESPACE_THRESHOLD")));
            t.start();
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to start disk monitoring", (Throwable)e);
            throw e;
        }
        try {
            JobExecutionManager.init(this.getPropertyAsBoolean("PURGE_PENDING_OBJECTS"));
            TableGenerationExecutionManager.init(this.getPropertyAsBoolean("PURGE_PENDING_HSPEC_REQUESTS"), this.getPropertyAsInteger("PROGRESS_MONITOR_INTERVAL_SEC"));
            AnalysisManager.init(true, this.getPropertyAsInteger("PROGRESS_MONITOR_INTERVAL_SEC"));
            SourceManager.checkTables();
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to start managers", (Throwable)e);
        }
        try {
            t = new DeletionMonitor(5000L);
            t.start();
            this.logger.info((Object)"Deletion Monitor started");
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to start Deletion Monitor ", (Throwable)e);
        }
    }

    protected void onShutdown() throws Exception {
        try {
            this.publisher.shutdown();
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to shutdown publisher ", (Throwable)e);
        }
        super.onShutdown();
    }

    protected void onFailure() throws Exception {
        super.onFailure();
    }

    public String getProperty(String paramName) throws Exception {
        return PropertiesReader.get(this.getFile("config.properties", new boolean[]{false}).getAbsolutePath()).getParam(paramName);
    }

    public Boolean getPropertyAsBoolean(String propertyName) throws Exception {
        return Boolean.parseBoolean(this.getProperty(propertyName));
    }

    public Integer getPropertyAsInteger(String propertyName) throws Exception {
        return Integer.parseInt(this.getProperty(propertyName));
    }

    public Double getPropertyAsDouble(String propertyName) throws Exception {
        return Double.parseDouble(this.getProperty(propertyName));
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public File getEcoligicalConfigDir() {
        return this.getFile("generator", new boolean[]{false});
    }

    public String getFolderPath(FOLDERS folderName) {
        String persistencePath = String.valueOf(ServiceContext.getContext().getPersistenceRoot().getAbsolutePath()) + File.separator + (Object)((Object)folderName);
        File f = new File(persistencePath);
        if (!f.exists()) {
            this.logger.debug((Object)("Creating persistence folder " + persistencePath));
            f.mkdirs();
            try {
                Process proc = Runtime.getRuntime().exec("chmod -R 777 " + persistencePath);
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {
                    int exitValue = proc.exitValue();
                    this.logger.debug((Object)("Permission execution exit value = " + exitValue));
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)"Unexpected Exception", (Throwable)e);
            }
        }
        return persistencePath;
    }

    public String getConfigurationScope() {
        return this.configurationScope;
    }

    public static enum FOLDERS {
        SERIALIZED,
        CLUSTERS,
        IMPORTS,
        TABLES,
        ANALYSIS;

    }
}

