/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.gcube.application.aquamaps.aquamapsservice.impl.CommonServiceLogic;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceGenerationRequestsManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorI;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.EnvironmentalLogicManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.TableGenerationConfiguration;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables.Execution;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables.TableGenerationExecutionManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ConfigurationManager;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.SourceGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.MetaSourceFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SourceGenerationRequestFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.LogicType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SourceGenerationPhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSPECGroupWorker
extends Thread {
    private SourceGenerationRequest request;
    static final Logger logger = LoggerFactory.getLogger(HSPECGroupWorker.class);
    final Semaphore blocking = new Semaphore(0);
    final List<String> exceptions = new ArrayList<String>();

    public HSPECGroupWorker(SourceGenerationRequest request) {
        this.request = request;
    }

    @Override
    public void run() {
        try {
            logger.trace("Starting execution for request ID " + this.request.getId());
            logger.debug("Request is " + this.request.toXML());
            SourceGenerationRequestsManager.setStartTime(this.request.getId());
            SourceGenerationRequestsManager.setPhasePercent(0.0, this.request.getId());
            ArrayList<ArrayList<Resource>> sourcesSubsets = HSPECGroupWorker.getComplexGenerationSubSets(this.request);
            if (sourcesSubsets.size() == 0) {
                throw new Exception("No valid sources subset for generation request " + this.request.getId());
            }
            int Ntabs_per_step = 1;
            if (this.request.getLogic().equals((Object)LogicType.HCAF)) {
                for (Field field : this.request.getGenerationParameters()) {
                    if (!field.getName().equals("NUM_INTERPOLATIONS")) continue;
                    Ntabs_per_step = field.getValueAsInteger() - 2;
                }
            }
            SourceGenerationRequestsManager.setEvaluatedComputationCount(sourcesSubsets.size() * this.request.getAlgorithms().size(), this.request.getId());
            SourceGenerationRequestsManager.setToGenerateTableCount(sourcesSubsets.size() * Ntabs_per_step * this.request.getAlgorithms().size(), this.request.getId());
            for (ArrayList arrayList : sourcesSubsets) {
                for (AlgorithmType algorithm : this.request.getAlgorithms()) {
                    BatchGeneratorI batch = null;
                    try {
                        batch = EnvironmentalLogicManager.getBatch(this.request.getSubmissionBackend());
                        logger.debug("Got batch Id " + batch.getReportId());
                        SourceGenerationRequestsManager.addReportId(batch.getReportId(), this.request.getId());
                        try {
                            HSPECGroupWorker.simpleExecution(algorithm, this.request, arrayList, batch, this);
                        }
                        catch (Exception e) {
                            logger.error("Failed single execution step for " + this.request.getId() + ", sources subset was " + Arrays.toString(arrayList.toArray()));
                        }
                    }
                    catch (Exception e) {
                        logger.error("Unexpected Exception ", (Throwable)e);
                        if (batch == null) continue;
                        this.release(batch);
                    }
                }
            }
            logger.debug("Going to wait for generations, acquiring " + sourcesSubsets.size() * this.request.getAlgorithms().size() + " permits, currently available : " + this.blocking.availablePermits());
            this.blocking.acquire(sourcesSubsets.size() * this.request.getAlgorithms().size());
            ArrayList generatedSources = SourceGenerationRequestsManager.getById(this.request.getId()).getGeneratedSources();
            logger.debug("Awaken process, generated " + generatedSources.size());
            if (generatedSources.size() == 0) {
                throw new Exception("No sources were generated/ registered. Check previous log.");
            }
            if (this.request.getLogic().equals((Object)LogicType.HSPEC)) {
                boolean bl;
                boolean bl2 = false;
                boolean generateMaps = false;
                boolean generateGis = false;
                for (Field f : this.request.getExecutionParameters()) {
                    if (f.getName().equals("FORCE_MAPS_REGENERATION")) {
                        bl = f.getValueAsBoolean();
                        continue;
                    }
                    if (f.getName().equals("GENERATE_MAPS")) {
                        generateMaps = f.getValueAsBoolean();
                        continue;
                    }
                    if (!f.getName().equals("GIS_ENABLED")) continue;
                    generateGis = f.getValueAsBoolean();
                }
                if (generateMaps) {
                    logger.trace("Generating jobs for request " + this.request.getId());
                    ArrayList<Integer> jobIds = new ArrayList<Integer>();
                    SourceGenerationRequestsManager.setPhase(SourceGenerationPhase.mapgeneration, this.request.getId());
                    for (Integer hspecId : generatedSources) {
                        Resource hspec = SourceManager.getById(hspecId);
                        logger.trace("Requesting job for hspec " + hspec.getTitle() + ", ID :" + hspec.getSearchId());
                        int jobID = CommonServiceLogic.generateMaps_Logic(hspec.getSearchId(), new ArrayList<Field>(), this.request.getAuthor(), generateGis, bl);
                        logger.trace("Job is " + jobID);
                        SourceGenerationRequestsManager.addJobIds(jobID, this.request.getId());
                        jobIds.add(jobID);
                    }
                    if (jobIds.size() > 0) {
                        logger.trace("Generation " + this.request.getId() + " : submitted  jobIds : " + jobIds);
                    }
                } else {
                    SourceGenerationRequestsManager.setPhase(SourceGenerationPhase.completed, this.request.getId());
                }
            } else {
                SourceGenerationRequestsManager.setPhase(SourceGenerationPhase.completed, this.request.getId());
            }
        }
        catch (Exception e) {
            logger.error("Unexpected Exception while executing request " + this.request.getId() + ", execution error messages were :", (Throwable)e);
            for (String msg : this.exceptions) {
                logger.error(msg);
            }
            try {
                SourceGenerationRequestsManager.setPhase(SourceGenerationPhase.error, this.request.getId());
            }
            catch (Exception e1) {
                logger.error("Unable to update phase , request was " + this.request, (Throwable)e);
            }
        }
    }

    private static Set<Resource> getExisting(AlgorithmType algorithm, List<Resource> sources, String currentRequestId, LogicType logic, ArrayList<Field> generationParameters) throws Exception {
        ArrayList<Field> requestFilter = new ArrayList<Field>();
        SourceGenerationRequest requestFilterModel = new SourceGenerationRequest();
        requestFilterModel.setGenerationParameters(generationParameters);
        requestFilterModel.setLogic(logic);
        requestFilter.add(requestFilterModel.getField(SourceGenerationRequestFields.logic));
        requestFilter.add(requestFilterModel.getField(SourceGenerationRequestFields.generationparameters));
        for (SourceGenerationRequest request : SourceGenerationRequestsManager.getList(requestFilter)) {
            if (request.getId().equals(currentRequestId) || !request.getAlgorithms().contains(algorithm) || !request.getPhase().equals((Object)SourceGenerationPhase.pending) && !request.getPhase().equals((Object)SourceGenerationPhase.datageneration)) continue;
            ArrayList<ArrayList<Resource>> subsets = HSPECGroupWorker.getComplexGenerationSubSets(request);
            boolean found = false;
            for (ArrayList<Resource> subset : subsets) {
                if (subset.size() == sources.size()) {
                    for (int i = 0; i < subset.size(); ++i) {
                        boolean bl = found = subset.get(i).getSearchId() == sources.get(i).getSearchId();
                        if (!found) break;
                    }
                }
                if (!found) continue;
                break;
            }
            if (!found) continue;
            logger.trace("Found existing request [PHASE : " + request.getPhase() + " ; ID : " + request.getId() + "], waiting for generation");
            int[] sourcesIds = new int[sources.size()];
            for (int i = 0; i < sourcesIds.length; ++i) {
                sourcesIds[i] = sources.get(i).getSearchId();
            }
            TableGenerationExecutionManager.signForGeneration(new Execution(algorithm, logic, sourcesIds, requestFilterModel.getField(SourceGenerationRequestFields.generationparameters).getValue()));
        }
        Resource filterModel = new Resource(ResourceType.valueOf((String)(logic + "")), 0);
        filterModel.setAlgorithm(algorithm);
        filterModel.setParameters(generationParameters);
        for (Resource r : sources) {
            filterModel.addSource(r);
        }
        ArrayList<Field> resourceFilter = new ArrayList<Field>();
        resourceFilter.add(filterModel.getField(MetaSourceFields.algorithm));
        resourceFilter.add(filterModel.getField(MetaSourceFields.sourcehcafids));
        resourceFilter.add(filterModel.getField(MetaSourceFields.sourcehspecids));
        resourceFilter.add(filterModel.getField(MetaSourceFields.sourcehspenids));
        resourceFilter.add(filterModel.getField(MetaSourceFields.sourceoccurrencecellsids));
        resourceFilter.add(filterModel.getField(MetaSourceFields.parameters));
        return SourceManager.getList(resourceFilter);
    }

    private static void simpleExecution(AlgorithmType algorithmType, final SourceGenerationRequest theRequest, final List<Resource> sourcesSubSet, BatchGeneratorI batch, final HSPECGroupWorker worker) throws Exception {
        batch.setConfiguration(ServiceContext.getContext().getFile("generator", new boolean[]{false}).getAbsolutePath() + File.separator, ConfigurationManager.getVODescriptor().getInternalDB());
        try {
            Set<Resource> existing = HSPECGroupWorker.getExisting(algorithmType, sourcesSubSet, theRequest.getId(), theRequest.getLogic(), theRequest.getGenerationParameters());
            if (existing.size() == 0) {
                logger.trace("No Resources found, submitting generation..");
                batch.generateTable(new TableGenerationConfiguration(theRequest.getLogic(), algorithmType, sourcesSubSet, theRequest.getSubmissionBackend(), theRequest.getExecutionEnvironment(), theRequest.getBackendURL(), theRequest.getEnvironmentConfiguration(), theRequest.getNumPartitions(), theRequest.getAuthor(), theRequest.getGenerationParameters(), worker){

                    @Override
                    public void registerGeneratedSourcesCallback(List<String> toRegisterTables) throws Exception {
                        List<Resource> toReturn = HSPECGroupWorker.registerSources(toRegisterTables, ResourceType.valueOf((String)(this.getLogic() + "")), this.getAlgorithm(), this.getAuthor(), theRequest.getDescription(), this.getExecutionEnvironment(), sourcesSubSet, theRequest.getGenerationname() + "_" + this.getAlgorithm(), this.getAdditionalParameters());
                        if (toReturn.size() == 0) {
                            throw new Exception("No tables were generated");
                        }
                        int[] sourcesIds = new int[sourcesSubSet.size()];
                        for (int i = 0; i < sourcesIds.length; ++i) {
                            sourcesIds[i] = ((Resource)sourcesSubSet.get(i)).getSearchId();
                        }
                        TableGenerationExecutionManager.notifyGeneration(new Execution(this.getAlgorithm(), theRequest.getLogic(), sourcesIds, theRequest.getField(SourceGenerationRequestFields.generationparameters).getValue()));
                        worker.notifyGenerated(toReturn);
                    }

                    @Override
                    public void notifyError(Exception e) {
                        logger.warn("Unexpected Exception", (Throwable)e);
                        int[] sourcesIds = new int[sourcesSubSet.size()];
                        for (int i = 0; i < sourcesIds.length; ++i) {
                            sourcesIds[i] = ((Resource)sourcesSubSet.get(i)).getSearchId();
                        }
                        try {
                            TableGenerationExecutionManager.notifyGeneration(new Execution(this.getAlgorithm(), theRequest.getLogic(), sourcesIds, theRequest.getField(SourceGenerationRequestFields.generationparameters).getValue()));
                        }
                        catch (Exception e2) {
                            logger.warn("Unable to notify pending generations... ", (Throwable)e2);
                        }
                        try {
                            worker.notifyException(e, new Execution(this.getAlgorithm(), theRequest.getLogic(), sourcesIds, theRequest.getField(SourceGenerationRequestFields.generationparameters).getValue()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void release(BatchGeneratorI batch) {
                        worker.release(batch);
                    }
                });
            } else {
                logger.trace("Found " + existing.size() + " existing sources ");
                ArrayList<Resource> generated = new ArrayList<Resource>();
                for (Resource r : existing) {
                    generated.add(r);
                }
                worker.notifyGenerated(generated);
                worker.release(batch);
            }
        }
        catch (Exception e) {
            logger.error("Unable to generate data for  algorithm " + algorithmType + " subset was : " + Arrays.toString(sourcesSubSet.toArray()), (Throwable)e);
            worker.release(batch);
        }
    }

    private static ArrayList<ArrayList<Resource>> getComplexGenerationSubSets(SourceGenerationRequest request) throws Exception {
        ArrayList<ArrayList<Resource>> toReturn = new ArrayList<ArrayList<Resource>>();
        switch (request.getLogic()) {
            case HSPEC: {
                boolean combineMatching = true;
                for (Field f : request.getExecutionParameters()) {
                    if (!f.getName().equals("COMBINE_MATCHING")) continue;
                    combineMatching = f.getValueAsBoolean();
                }
                if (request.getHcafIds().size() == 0) {
                    throw new Exception("No HCAF resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                if (request.getHspenIds().size() == 0) {
                    throw new Exception("No HSPEN resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                for (Integer hcafId : request.getHcafIds()) {
                    Resource hcaf = SourceManager.getById(hcafId);
                    if (hcaf == null) {
                        logger.warn("Selected HCAF Resource [ID = " + hcafId + " ] was null , skipping..");
                        continue;
                    }
                    for (Integer hspenId : request.getHspenIds()) {
                        Resource hspen = SourceManager.getById(hspenId);
                        if (combineMatching && !hspen.getSourceHCAFIds().contains(hcafId)) {
                            logger.debug("HSPEN (" + hspenId + ")doesn't match current hcaf (" + hcafId + "), hspen sources where " + hspen.getSourceHCAFIds());
                            continue;
                        }
                        if (hcaf == null) {
                            logger.warn("Selected HSPEN Resource [ID = " + hspenId + " ] was null , skipping..");
                            continue;
                        }
                        toReturn.add(new ArrayList<Resource>(Arrays.asList(hcaf, hspen)));
                    }
                }
                break;
            }
            case HSPEN: {
                if (request.getHcafIds().size() == 0) {
                    throw new Exception("No HCAF resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                if (request.getHspenIds().size() == 0) {
                    throw new Exception("No HSPEN resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                if (request.getOccurrenceCellIds().size() == 0) {
                    throw new Exception("No Occurrence Cells resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                for (Integer hcafId : request.getHcafIds()) {
                    Resource hcaf = SourceManager.getById(hcafId);
                    if (hcaf == null) {
                        logger.warn("Selected HCAF Resource [ID = " + hcafId + " ] was null , skipping..");
                        continue;
                    }
                    for (Integer hspenId : request.getHspenIds()) {
                        Resource hspen = SourceManager.getById(hspenId);
                        if (hspen == null) {
                            logger.warn("Selected HSPEN Resource [ID = " + hspenId + " ] was null , skipping..");
                            continue;
                        }
                        for (Integer occurId : request.getOccurrenceCellIds()) {
                            Resource occurrence = SourceManager.getById(occurId);
                            if (occurrence == null) {
                                logger.warn("Selected Occurrence Cells Resource [ID = " + occurId + " ] was null , skipping..");
                                continue;
                            }
                            toReturn.add(new ArrayList<Resource>(Arrays.asList(hcaf, hspen, occurrence)));
                        }
                    }
                }
                break;
            }
            case HCAF: {
                if (request.getHcafIds().size() == 0) {
                    throw new Exception("No HCAF resources found for request " + request.getId() + ", Logic was " + request.getLogic());
                }
                ArrayList<Resource> sources = new ArrayList<Resource>();
                for (Integer hcafId : request.getHcafIds()) {
                    Resource hcaf = SourceManager.getById(hcafId);
                    if (hcaf == null) {
                        throw new Exception("Selected HCAF Resource [ID = " + hcafId + " ] was null , skipping..");
                    }
                    sources.add(hcaf);
                }
                toReturn.add(sources);
                break;
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Resource> registerSources(List<String> toRegister, ResourceType type, AlgorithmType alg, String author, String description, String environment, List<Resource> sources, String titlePattern, ArrayList<Field> additionalParameters) throws Exception {
        ArrayList<String> unregisteredTables = new ArrayList<String>();
        ArrayList<Resource> toReturn = new ArrayList<Resource>();
        for (int i = 0; i < toRegister.size(); ++i) {
            String generatedTable = toRegister.get(i);
            try {
                Long count;
                Resource toRegisterSource;
                block17: {
                    toRegisterSource = new Resource(type, 0);
                    toRegisterSource.setAlgorithm(alg);
                    toRegisterSource.setAuthor(author);
                    toRegisterSource.setGenerationTime(Long.valueOf(System.currentTimeMillis()));
                    toRegisterSource.setDescription(description);
                    toRegisterSource.setProvenance("Generated on AquaMaps VRE, submitted on " + environment);
                    for (Resource r : sources) {
                        toRegisterSource.addSource(r);
                    }
                    toRegisterSource.setStatus(ResourceStatus.Completed);
                    toRegisterSource.setTableName(generatedTable);
                    toRegisterSource.setParameters(additionalParameters);
                    String title = toRegister.size() > 1 ? titlePattern + "_step" + i : titlePattern;
                    toRegisterSource.setTitle(title);
                    count = 0L;
                    DBSession session = null;
                    try {
                        session = DBSession.getInternalDBSession();
                        if (session.checkTableExist(generatedTable)) {
                            count = session.getTableCount(generatedTable);
                            break block17;
                        }
                        throw new Exception("TABLE " + generatedTable + " NOT FOUND!!");
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                toRegisterSource.setRowCount(count);
                toRegisterSource = SourceManager.registerSource(toRegisterSource);
                logger.trace("Registered Resource with id " + toRegisterSource.getSearchId());
                toReturn.add(toRegisterSource);
                continue;
            }
            catch (Exception e) {
                unregisteredTables.add(generatedTable);
                logger.error("Unable to register source table " + generatedTable, (Throwable)e);
                DBSession session = null;
                try {
                    session = DBSession.getInternalDBSession();
                    if (!session.checkTableExist(generatedTable)) continue;
                    session.dropTable(generatedTable);
                    continue;
                }
                catch (Exception e1) {
                    logger.warn("Unable to delete table " + generatedTable, (Throwable)e);
                    continue;
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
        }
        return toReturn;
    }

    public void notifyGenerated(List<Resource> generated) throws Exception {
        for (Resource r : generated) {
            SourceGenerationRequestsManager.addGeneratedResource(r.getSearchId(), this.request.getId());
        }
        this.blocking.release();
    }

    public void notifyException(Exception e, Execution exec) {
        this.exceptions.add("Execution " + exec + " threw exception : " + e.getMessage());
        this.blocking.release();
    }

    public void release(BatchGeneratorI batch) {
        logger.debug("leaving batch ID " + batch.getReportId());
        try {
            if (batch != null) {
                EnvironmentalLogicManager.leaveBatch(batch);
                SourceGenerationRequestsManager.removeReportId(batch.getReportId(), this.request.getId());
            }
        }
        catch (Exception e) {
            logger.error("Unable to leave generator", (Throwable)e);
        }
    }
}

