/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.util.FileUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportCSVSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportOperation;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportTableStatusType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.utils.Storage;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportManager
extends Thread {
    static final Logger logger = LoggerFactory.getLogger(ExportManager.class);
    private static final String EXPORT_REFERENCE_TABLE = "exports";
    private static final String EXPORT_ID = "id";
    private static final String EXPORT_TABLE = "toexporttable";
    private static final String EXPORT_SETTINGS = "settings";
    private static final String EXPORT_STATUS = "status";
    private static final String EXPORT_ERROR_MSG = "errors";
    private static final String EXPORT_LOCAL_PATH = "localpath";
    private static final String EXPORT_TIME = "time";
    private static final String EXPORT_LOCATOR = "locator";
    private static final String EXPORT_SCOPE = "scope";
    private static final String EXPORT_OPERATION = "operation";
    private static final String EXPORT_USER = "username";
    private static final String EXPORT_BASKET = "basket";
    private static final String EXPORT_NAME = "name";
    private String referenceId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String submitExportOperation(String tableName, String user, String basket, String name, ExportOperation operation, ExportCSVSettings settings) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            String referenceId = ServiceUtils.generateId("EXPORT", "").toLowerCase();
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field(EXPORT_ID, referenceId, FieldType.STRING));
            row.add(new Field(EXPORT_TABLE, tableName, FieldType.STRING));
            row.add(new Field(EXPORT_SETTINGS, AquaMapsXStream.getXMLInstance().toXML((Object)settings), FieldType.STRING));
            row.add(new Field(EXPORT_STATUS, "PENDING", FieldType.STRING));
            row.add(new Field(EXPORT_SCOPE, ServiceContext.getContext().getScope() + "", FieldType.STRING));
            row.add(new Field(EXPORT_OPERATION, operation.toString(), FieldType.STRING));
            row.add(new Field(EXPORT_USER, user, FieldType.STRING));
            row.add(new Field(EXPORT_BASKET, basket, FieldType.STRING));
            row.add(new Field(EXPORT_NAME, name, FieldType.STRING));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(row);
            session.insertOperation(EXPORT_REFERENCE_TABLE, rows);
            ExportManager thread = new ExportManager(referenceId);
            thread.start();
            String string = referenceId;
            return string;
        }
    }

    public static ExportTableStatusType getStatus(String requestId) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> field = new ArrayList<Field>();
            field.add(new Field(EXPORT_ID, requestId, FieldType.STRING));
            ResultSet rs = session.executeFilteredQuery(field, EXPORT_REFERENCE_TABLE, EXPORT_ID, OrderDirection.ASC);
            if (rs.next()) {
                ExportTableStatusType status = new ExportTableStatusType();
                status.setCsvSettings((ExportCSVSettings)AquaMapsXStream.getXMLInstance().fromXML(rs.getString(EXPORT_SETTINGS)));
                status.setStatus(ExportStatus.fromValue((String)rs.getString(EXPORT_STATUS)));
                status.setRsLocator(rs.getString(EXPORT_LOCATOR));
                status.setTableName(rs.getString(EXPORT_TABLE));
                status.setErrors(rs.getString(EXPORT_ERROR_MSG));
                logger.debug("Found export status [refID:" + requestId + "] : " + status.getStatus() + "," + status.getTableName() + "," + status.getRsLocator());
                ExportTableStatusType exportTableStatusType = status;
                return exportTableStatusType;
            }
            throw new Exception("Reference " + requestId + " not found");
        }
    }

    private static int updateField(String id, String field, FieldType objectType, Object value) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(EXPORT_ID, id, FieldType.STRING));
            keys.add(filter);
            ArrayList<List<Field>> values = new ArrayList<List<Field>>();
            ArrayList<Field> valueList = new ArrayList<Field>();
            valueList.add(new Field(field + "", value + "", objectType));
            values.add(valueList);
            int n = session.updateOperation(EXPORT_REFERENCE_TABLE, keys, values);
            return n;
        }
    }

    private ExportManager(String referenceId) {
        this.referenceId = referenceId;
        this.setName("EXPORTER_" + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String tmpFileName;
        DBSession session;
        block17: {
            session = null;
            boolean found = false;
            tmpFileName = null;
            try {
                ExportManager.updateField(this.referenceId, EXPORT_STATUS, FieldType.STRING, "ONGOING");
                session = DBSession.getInternalDBSession();
                ArrayList<Field> field = new ArrayList<Field>();
                field.add(new Field(EXPORT_ID, this.referenceId, FieldType.STRING));
                ResultSet rs = session.executeFilteredQuery(field, EXPORT_REFERENCE_TABLE, EXPORT_ID, OrderDirection.ASC);
                if (!rs.next()) throw new Exception("Reference " + this.referenceId + " not found");
                found = true;
                ExportCSVSettings settings = (ExportCSVSettings)AquaMapsXStream.getXMLInstance().fromXML(rs.getString(EXPORT_SETTINGS));
                tmpFileName = session.exportTableToCSV(rs.getString(EXPORT_TABLE), settings.isHasHeader(), settings.getDelimiter().charAt(0));
                ExportManager.updateField(this.referenceId, EXPORT_LOCAL_PATH, FieldType.STRING, tmpFileName);
                String scope = rs.getString(EXPORT_SCOPE);
                ExportOperation operation = ExportOperation.fromString((String)rs.getString(EXPORT_OPERATION));
                if (operation.equals((Object)ExportOperation.SAVE)) {
                    String owner = rs.getString(EXPORT_USER);
                    String destinationBasketId = rs.getString(EXPORT_BASKET);
                    String toSaveName = rs.getString(EXPORT_NAME);
                    logger.debug("Getting workspace for user " + owner + " under scope " + scope);
                    ScopeProvider.instance.set(scope);
                    HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
                    Workspace workspace = factory.getHomeManager().getHome(owner).getWorkspace();
                    workspace.createExternalFile(toSaveName, "Exported table", "text/csv", (InputStream)new FileInputStream(tmpFileName), destinationBasketId);
                    logger.debug("File saved into user's workspace");
                } else {
                    String id = Storage.storeFile((String)new File(tmpFileName).getAbsolutePath(), (boolean)false);
                    logger.trace("Storage id " + id);
                    ExportManager.updateField(this.referenceId, EXPORT_LOCATOR, FieldType.STRING, id);
                }
                ExportManager.updateField(this.referenceId, EXPORT_TIME, FieldType.LONG, System.currentTimeMillis());
                ExportManager.updateField(this.referenceId, EXPORT_STATUS, FieldType.STRING, ExportStatus.COMPLETED);
                if (session == null) break block17;
            }
            catch (Exception e) {
                if (!found) return;
                try {
                    ExportManager.updateField(this.referenceId, EXPORT_ERROR_MSG, FieldType.STRING, e.getMessage());
                    ExportManager.updateField(this.referenceId, EXPORT_STATUS, FieldType.STRING, "ERROR");
                    return;
                }
                catch (Exception e1) {
                    logger.error("Unable to update export reference id  " + this.referenceId, (Throwable)e);
                    return;
                }
            }
            try {
                session.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tmpFileName == null) return;
        FileUtils.delete((File)new File(tmpFileName));
        return;
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception e) {}
            }
            if (tmpFileName != null) {
                FileUtils.delete((File)new File(tmpFileName));
            }
        }
    }
}

