/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis;

import java.util.ArrayList;
import java.util.Iterator;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.AnalysisTableManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalyzerFactory;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.AnalysisFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalysisUpdaterThread
extends Thread {
    static final Logger logger = LoggerFactory.getLogger(AnalysisUpdaterThread.class);
    private long millis;

    public AnalysisUpdaterThread(long millis) {
        super("Analysis status updater");
        this.millis = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: while (true) {
            try {
                ArrayList<Field> filter = new ArrayList<Field>();
                filter.add(new Field(AnalysisFields.status + "", SubmittedStatus.Generating + "", FieldType.STRING));
                Iterator<Analysis> i$ = AnalysisTableManager.getList(filter).iterator();
                while (true) {
                    if (!i$.hasNext()) continue block13;
                    Analysis reference = i$.next();
                    try {
                        Double percent = (double)reference.getPerformedAnalysis().size() / (double)reference.getType().size() * 100.0;
                        StringBuilder logBuilder = new StringBuilder(" performed Size = " + reference.getPerformedAnalysis().size());
                        logBuilder.append("to perform size =" + reference.getType().size());
                        for (Integer reportId : reference.getReportID()) {
                            Double reportStatus = AnalyzerFactory.getReport(reportId, false).getPercent();
                            percent = percent + reportStatus / (double)reference.getType().size();
                            logBuilder.append("reportId " + reportId + " status " + reportStatus);
                        }
                        logger.debug("Updateing reference : " + reference.getId() + ", percent " + percent + ", forumla details " + logBuilder);
                        AnalysisTableManager.setPhasePercent(percent, reference.getId());
                    }
                    catch (Exception e) {
                        logger.warn("Skipping percent update for analysis id " + reference.getId() + ", report id was " + reference.getReportID(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unexpected exception ", (Throwable)e);
                continue;
            }
            finally {
                try {
                    Thread.sleep(this.millis);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }
}

