/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.StackKeyedObjectPoolFactory;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ConfigurationManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolManager {
    static final Logger logger = LoggerFactory.getLogger(PoolManager.class);
    private static GenericObjectPool internalDBconnectionPool;
    private static ConnectionFactory internalDBconnectionFactory;
    private static PoolableConnectionFactory internalDBpoolableConnectionFactory;
    private static PoolingDriver internalDBdriver;
    private static final String internalDBPoolName = "mySqlPool";
    private static final String postGISPoolName = "postGISPool";
    private static GenericObjectPool postGISconnectionPool;
    private static ConnectionFactory postGISconnectionFactory;
    private static PoolableConnectionFactory postGISpoolableConnectionFactory;
    private static PoolingDriver postGISdriver;
    private static String validationQUERY;
    private static String internalDBconnectionString;

    static {
        validationQUERY = "Select 1";
        internalDBconnectionString = null;
        try {
            DBDescriptor internalDBDescriptor = ConfigurationManager.getVODescriptor().getInternalDB();
            try {
                switch (internalDBDescriptor.getType()) {
                    case mysql: {
                        Class.forName("com.mysql.jdbc.Driver");
                        internalDBconnectionString = "jdbc:mysql:";
                        break;
                    }
                    case postgres: {
                        Class.forName("org.postgresql.Driver");
                        internalDBconnectionString = "jdbc:postgresql:";
                        break;
                    }
                    default: {
                        throw new ClassNotFoundException("Not Valid internal DB Type " + (Object)((Object)internalDBDescriptor.getType()));
                    }
                }
                internalDBconnectionString = String.valueOf(internalDBconnectionString) + internalDBDescriptor.getEntryPoint();
            }
            catch (ClassNotFoundException e) {
                logger.error("Unable to instantiate driver", (Throwable)e);
                throw e;
            }
            internalDBconnectionPool = new GenericObjectPool(null);
            internalDBconnectionPool.setMaxActive(internalDBDescriptor.getMaxConnection().intValue());
            internalDBconnectionPool.setTestOnBorrow(true);
            internalDBconnectionPool.setWhenExhaustedAction((byte)1);
            internalDBconnectionFactory = new DriverManagerConnectionFactory(internalDBconnectionString, internalDBDescriptor.getUser(), internalDBDescriptor.getPassword());
            internalDBpoolableConnectionFactory = new PoolableConnectionFactory(internalDBconnectionFactory, (ObjectPool)internalDBconnectionPool, (KeyedObjectPoolFactory)new StackKeyedObjectPoolFactory(), validationQUERY, false, true);
            internalDBdriver = new PoolingDriver();
            internalDBdriver.registerPool(internalDBPoolName, (ObjectPool)internalDBconnectionPool);
            DBDescriptor postgisDBDescriptor = ConfigurationManager.getVODescriptor().getGeoDb();
            try {
                Class.forName("org.postgresql.Driver");
            }
            catch (ClassNotFoundException e) {
                logger.error("Unable to instantiate driver", (Throwable)e);
                throw e;
            }
            postGISconnectionPool = new GenericObjectPool(null);
            postGISconnectionPool.setMaxActive(postgisDBDescriptor.getMaxConnection().intValue());
            postGISconnectionPool.setTestOnBorrow(true);
            postGISconnectionPool.setWhenExhaustedAction((byte)1);
            postGISconnectionFactory = new DriverManagerConnectionFactory("jdbc:postgresql:" + postgisDBDescriptor.getEntryPoint(), postgisDBDescriptor.getUser(), postgisDBDescriptor.getPassword());
            postGISpoolableConnectionFactory = new PoolableConnectionFactory(postGISconnectionFactory, (ObjectPool)postGISconnectionPool, (KeyedObjectPoolFactory)new StackKeyedObjectPoolFactory(), validationQUERY, false, true);
            postGISdriver = new PoolingDriver();
            postGISdriver.registerPool(postGISPoolName, (ObjectPool)postGISconnectionPool);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public static Connection getInternalDBConnection() throws Exception {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:mySqlPool");
    }

    public static Connection getPostGisDBConnection() throws Exception {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:postGISPool");
    }

    public static String getInternalConnectionString() {
        return internalDBconnectionString;
    }
}

