/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.util.FileUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads.StatefullCSVLineProcessor;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.utils.Storage;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceImporter
extends Thread {
    static final Logger logger = LoggerFactory.getLogger(SourceImporter.class);
    private String csv;
    private String locator;
    private Resource importing;
    private Integer metaId;
    private char delimiter;
    private boolean[] fieldSelection;
    private boolean hasHeaders;
    private String encoding;
    private String scope;

    public SourceImporter(String locator, Resource i, Integer metaId, char delimiter, boolean[] fieldSelection, boolean hasHeaders, String encoding) {
        this.locator = locator;
        this.importing = i;
        this.metaId = metaId;
        this.delimiter = delimiter;
        this.fieldSelection = fieldSelection;
        this.hasHeaders = hasHeaders;
        this.encoding = encoding;
        this.scope = ScopeProvider.instance.get();
    }

    @Override
    public void run() {
        DBSession session = null;
        StatefullCSVLineProcessor lineProcessor = null;
        try {
            try {
                this.csv = String.valueOf(ServiceContext.getContext().getFolderPath(ServiceContext.FOLDERS.IMPORTS)) + File.separator + ServiceUtils.generateId("import", ".csv");
                logger.debug("Importing file from locator " + this.locator + " to file " + this.csv + " under scope " + this.scope);
                ScopeProvider.instance.set(this.scope);
                FileWriter writer = new FileWriter(this.csv);
                FileInputStream is = new FileInputStream(Storage.getFileById((String)this.locator, (boolean)false, (String)"AquaMaps Service Importer"));
                IOUtils.copy((InputStream)is, (Writer)writer, (String)this.encoding);
                IOUtils.closeQuietly((Writer)writer);
                IOUtils.closeQuietly((InputStream)is);
                logger.debug("Started importing operation from " + this.csv + " TO " + this.importing.getTableName());
                long toInsertCount = CSVUtils.countCSVRows((String)this.csv, (char)this.delimiter, (boolean)this.hasHeaders);
                if (toInsertCount == 0L) {
                    throw new Exception("No rows to insert from csv file " + this.csv);
                }
                logger.info("Found " + toInsertCount + " rows in csv file");
                Resource defaultResource = SourceManager.getById(SourceManager.getDefaultId(this.importing.getType()));
                session = DBSession.getInternalDBSession();
                logger.debug("Going to evaluate default table " + defaultResource.getTableName() + " fields");
                ResultSet templateRs = session.executeQuery("SELECT * FROM " + defaultResource.getTableName() + " LIMIT 1 OFFSET 0");
                templateRs.next();
                List model = Field.loadRow((ResultSet)templateRs);
                session.close();
                CSVReaderProcessor processor = new CSVReaderProcessor();
                processor.setDelimiter(this.delimiter);
                processor.setHasHeader(this.hasHeaders);
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.csv), Charset.defaultCharset());
                lineProcessor = new StatefullCSVLineProcessor(model, this.importing, toInsertCount, this.fieldSelection);
                logger.debug("Starting file processing");
                processor.processStream((Reader)reader, (CSVLineProcessor)lineProcessor);
                logger.debug("Complete processing");
                logger.debug("Completed import of source ID " + this.importing.getSearchId());
            }
            catch (Exception e) {
                logger.error("Unexpected Exception ", (Throwable)e);
                this.importing.setStatus(ResourceStatus.Error);
                try {
                    SourceManager.update(this.importing);
                }
                catch (Exception e1) {
                    logger.error("Unable to update resource " + this.metaId, (Throwable)e1);
                }
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception e2) {
                        logger.error("Unable to close session ", (Throwable)e2);
                    }
                }
                if (lineProcessor != null) {
                    lineProcessor.close();
                }
                FileUtils.delete((File)new File(this.csv));
            }
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    logger.error("Unable to close session ", (Throwable)e);
                }
            }
            if (lineProcessor != null) {
                lineProcessor.close();
            }
            FileUtils.delete((File)new File(this.csv));
        }
    }
}

